
## Setup

We use the following variables (to be registered in `~/.bashrc`)
```bash
export OPENAI_API_KEY=
export HF_TOKEN=
export HF_ALLOW_CODE_EVAL=1
```

First, Create a virtual invironment

with [Miniconda](https://www.anaconda.com/docs/getting-started/miniconda/install)
```bash
conda create -n prune python=3.12
conda activate prune
```
or with venv
```bash
python -m venv .venv
source .venv/bin/activate
```

Then, install libraries and datasets
```bash
bash install.sh
```

`install.sh` includes installation of vllm. However, if it does not work for some reason, you can comment it out, and the code automatically falls back to docker based approach. In this case, you instead need to pull the image:

```bash
docker pull ghcr.io/lambdalabsml/vllm-builder:v0.10.0
```

Check `class VLLMRunner` for details.

## Pipeline

Check `bash scripts/eval.sh --help`