import json

input_file = "jailbreak.jsonl"
bad_file = "jailbreak_rejected.jsonl"
good_file = "jailbreak_chosen.jsonl"

with open(input_file) as f_in, open(bad_file, "w") as f_bad, open(good_file, "w") as f_good:
    for line in f_in:
        data = json.loads(line)

        prompt = data["instruction"]

        bad_entry = {"instruction": prompt, "output": data["rejected"]}
        good_entry = {"instruction": prompt, "output": data["chosen"]}

        f_bad.write(json.dumps(bad_entry) + "\n")
        f_good.write(json.dumps(good_entry) + "\n")
