# Requirements

Requirements mentioned in requirements.txt
For installing robustbench, ml_collections, libmer one could use,  <br />

pip install git+https://github.com/RobustBench/robustbench.git     <br />
pip install ml_collections                                         <br />
pip install libmr              



# Usage

Note: For all experiments working directory should be the root of the project. For example, you could copy the file to the root and then execute it.
### Reproduce Table 1 results.
Run "table1/in_dataset_name/model_name.py"
to get the result of the model with the one mentioned in-dataset.
For example,
running "experiment/table1/cifar10/ALOE.py" will show the result of ALOE model, trained on Cifar10 dataset.<br />

### Reproduce Table 4 OSAD results.
Run "python experiment/table4.py".

### Reproduce Figure 1 results.
Run "python experiment/fig1.py id".        <br />
id=1 for OSAD results           <br />
id=2 for ALOE results           <br />
id=3 for ViT results            <br />
id=4 for AT results             <br />
For example running "python experiment/fig1.py 1" will print the result of OSAD model.

### Reproduce Figure 2 results.
Run "python experiment/fig2.py". The plot will be saved in fig2.py.

### Reproduce Figure 5 images.
Run "python experiment/fig5.py". This will create images and save them into results/images/datasetname--score_before_atack--score_after_atack[AC].png.
A means this image is the adversarial one and C means it is the standard one. 

### Reproduce Figure 6.
Run "python experiment/fig6.py".

# References
Code from

ATOM: Robustifying Out-of-distribution Detection Using Outlier Mining, Chen, https://github.com/jfc43/informative-outlier-mining
Open-set adversarial defense, Shao, et al. https://github.com/rshaojimmy/ECCV2020-OSAD
.                                                        <br />
Robust Out-of-distribution Detection in Neural Networks, Chen, et al. https://github.com/jfc43/robust-ood-detection
.                           <br />
Overfitting in adversarially robust deep learning, Rice et al. https://github.com/locuslab/robust_overfitting
.                                 <br />
RobustBench: a standardized adversarial robustness benchmark, Croce et al. https://github.com/RobustBench/robustbench
.                         <br />
An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale, Dosovitskiy et
al. https://github.com/jeonsworld/ViT-pytorch.      <br />
Adversarial vulnerability of powerful near out-of-distribution detection,
Fort. https://github.com/stanislavfort/adversaries_to_OOD_detection.
