import glob
import json
import os
import re
import shutil

file_list = glob.glob('*.jsonl')

for file_name in file_list:
    print(file_name)
    with open(file_name, 'r') as f:
        data = [json.loads(line) for line in f.readlines()]

    for d in data:
        if -1 == d['score']:
            try:
                # last line is a number
                score = '\n'.join(d['text'].strip().split('\n')[-2:])
                if score in ['1', '2', '3']:
                    d['score'] = int(score)
                    continue
    
                # choose[:] 1/2
                extract = re.search('choose(:)? (\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(2))
                    continue

                # the number 1/2
                extract = re.search('the number (\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(1))
                    continue

                # I would choose Assistant 1/2\'s
                extract = re.search('I would choose Assistant (\d)\'s', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(1))
                    continue

                # i will|would output (a) 3
                extract = re.search('i (will|would) output (a )?(\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(3))
                    continue

                # the number [to output] is: 1/2/3
                extract = re.search('the number (to output )?is(:)? (\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(3))
                    continue

                # output: 3.
                extract = re.search('output: (\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(1))
                    continue

                # I am choosing 3
                extract = re.search('I am choosing (\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(1))
                    continue

                # the answer is 3
                extract = re.search('the answer (to this question )?is (\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(2))
                    continue

                # i would recommend choosing 3
                extract = re.search('i would recommend choosing (\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(1))
                    continue

                # Assistant 2's response is the better choice
                extract = re.search('Assistant (\d)\'s response is the better choice', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(1))
                    continue

                # the preference would be assistant 1
                extract = re.search('the preference would be assistant (\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(1))
                    continue

                # there is no need to output a number
                extract = re.search('there is no need to output a number', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = 3
                    continue

                # the response from assistant 1 is the better
                extract = re.search('the response from assistant (\d) is the better', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(1))
                    continue

                # the output for this last line is 3
                extract = re.search('the output for this last line is (\d)', score, re.IGNORECASE)
                if extract is not None:
                    d['score'] = int(extract.group(1))
                    continue

                raise Error

            except:
                print(json.dumps(d, indent=2))
                d['score'] = int(input('score:'))

    with open(os.path.join('../', file_name), 'w') as f:
        for d in data:
            f.write(json.dumps(d) + '\n')

    shutil.move(file_name, 'done/'+file_name)
    input('press Enter to continue')

