import json

import shortuuid
from tqdm import tqdm
import zephyr

MODEL_ID = 'zephyr'

with open('../data/vicuna80/vicuna_questions.jsonl', 'r') as f:
    data = [json.loads(line) for line in f.readlines()]

def call(question):
    prompt = [{'role': 'system', 'content': question[0]},
              {'role': 'user', 'content': question[1]}]
    
    prediction = zephyr.call(prompt, max_tokens=1000)

    return prediction
 
answers = []
for d in tqdm(data):
    idx = d['question_id']
    question = d['text']
    category = d['category']

    answer = call(['You are a useful assistant.', question])

    answers.append({"answer_id": shortuuid.uuid(),
                    "question_id": idx,
                    "model_id": MODEL_ID,
                    "text": answer})

with open('../data/vicuna80/generations/answer_zephyr.jsonl', 'w') as f:
    for answer in answers:
        f.write(json.dumps(answer) + '\n')

