# Training

## FREED
Environment: Docker freedpp/Dockerfile
```bash
python run_rl.py \
    --mode "train+gen" \
    --has_feature 1 \
    --min_action 1 \
    --max_action 4 \
    --graph_emb 1 \
    --gcn_aggregate sum \
    --gcn_type GCN \
    --intr_rew 0 \
    --intr_rew_ratio 0.5 \
    --update_after 2000 \
    --start_steps 3000 \
    --update_every 256 \
    --init_alpha 1.0 \
    --desc ecfp \
    --rl_model sac \
    --active_learning freed_pe \
    --gpu_id 0 \
    --emb_size 64 \
    --tau 0.1 \
    --batch_size 128 \
    --target_entropy 0.05 \
    --exp_root /home/user/experiments/freed/FREED/usp7 \
    --save_freq 5000 \
    --steps_per_epoch 500 \
    --epochs 100 \
    --num_sub_proc 12 \
    --target usp7
```

## FREED++
Environment: Docker freedpp/Dockerfile
```bash
python main.py \
    --exp_root /home/user/freed/experiments/freedpp/docking_score_optimization/n4/crem_zinc/fkb1a \
    --alert_collections /home/user/freed/big_files/alert_collections.csv \
    --fragments /home/user/freed/big_files/motifs/zinc_crem/zinc_crem.json \
    --receptor /home/user/freed/big_files/receptors/fkb1a.pdbqt \
    --vina_program /home/user/freed/big_files/bin/qvina02 \
    --starting_smile "c1([*:1])c([*:2])ccc([*:3])c1" \
    --fragmentation crem \
    --num_sub_proc 11 \
    --n_conf 1 \
    --exhaustiveness 1 \
    --save_freq 50 \
    --epochs 200 \
    --commands "train,sample" \
    --reward_version soft \
    --box_center " -35.137,39.04,32.495" \
    --box_size "8.453,13.483,8.112" \
    --seed 150 \
    --name 150
```

## FFREED
Environment: Docker freedpp/Dockerfile
```bash
python main.py \
    --exp_root /home/user/freed/experiments/ffreed/docking_score_optimization/n4/crem_zinc/fkb1a \
    --alert_collections /home/user/freed/big_files/alert_collections.csv \
    --fragments /home/user/freed/big_files/motifs/zinc_crem/zinc_crem.json \
    --receptor /home/user/freed/big_files/receptors/fkb1a.pdbqt \
    --vina_program /home/user/freed/big_files/bin/qvina02 \
    --starting_smile "c1([*:1])c([*:2])ccc([*:3])c1" \
    --fragmentation crem \
    --num_sub_proc 11 \
    --n_conf 1 \
    --exhaustiveness 1 \
    --save_freq 50 \
    --epochs 200 \
    --commands "train,sample" \
    --reward_version soft \
    --box_center " -35.137,39.04,32.495" \
    --box_size "8.453,13.483,8.112" \
    --seed 150 \
    --name 150 \
    --action_mechanism sfps \
    --per True \
    --merger mi
```

## REINVENT
Environment: Docker freedpp/Dockerfile
```bash
python main.py \
    --batch-size 32 \
    --num-steps 3000 \
    --save-dir '/home/user/freed/experiments/reinvent/usp7/sigma_60/150' \
    --seed 150
    --sigma' 60
    --scoring-function docking_score \
    --scoring-function-kwargs "exhaustiveness 1 n_conf 1 num_modes 10 error_val 99.9 alpha 0.1 timeout_dock 90 timeout_gen3d 30 receptor_file /home/user/freed/big_files/receptors/usp7.pdbqt box_center (2.860,4.819,92.848) box_size (17.112,17.038,14.958) vina_program /home/user/freed/big_files/qvina02 num_sub_proc 12 seed 150 temp_dir /home/user/freed/experiments/reinvent/usp7/sigma_60/150/tmp"
```

## MolDQN
Environment: Docker freedpp/Dockerfile
### Dense rewards
```bash
python main.py \
    --exp_root /home/user/freed/experiments/moldqn/dense_rewards/fa7 \
    --num_sub_proc 12 \
    --receptor_file /home/user/freed/big_files/receptors/fa7.pdbqt \
    --vina_program /home/user/freed/big_files/qvina02 \
    --box_center "10.131,41.879,32.097" \
    --box_size "20.673,20.198,21.362" \
    --seed 150 \
    --name 150
```

### Sparse rewards
```bash
python main.py \
    --exp_root /home/user/freed/experiments/moldqn/sparse_rewards/fa7 \
    --num_sub_proc 12 \
    --receptor_file /home/user/freed/big_files/receptors/fa7.pdbqt \
    --vina_program /home/user/freed/big_files/qvina02 \
    --update_interval 480 \
    --num_updates_per_it 24 \
    --use_dense_rewards False \
    --box_center "10.131,41.879,32.097" \
    --box_size "20.673,20.198,21.362" \
    --seed 150 \
    --name 150
```

## CombGen
Reference: https://github.com/molecularsets/moses/blob/master/moses/baselines/combinatorial.py
Environment: Docker (https://github.com/molecularsets/moses/blob/master/Dockerfile)

```bash
python combinatorial.py \
    --n_jobs 16
```

## Pocket2Mol
Reference: https://github.com/pengxingang/Pocket2Mol
Environment: Conda (https://github.com/pengxingang/Pocket2Mol/blob/main/env_cuda113.yml)

```bash
python sample_for_pdb.py \
    --pdb_path /home/user/freed/big_files/receptors/usp7.pdb \
    --center "2.860,4.819,92.848" \
    --outdir /home/user/freed/experiments/pocket2mol/usp7 \
    --config config
```

# Evaluation
Environment: Docker freedpp/Dockerfile
```bash
python main.py \
    --exp_root /home/user/freed/experiments \
    --alert_collections /home/user/freed/data/alert_collections.csv \
    --fragments /home/user/freed/data/motifs/zinc_crem.json \
    --receptor /home/user/freed/data/receptors/protein.pdbqt \
    --vina_program /home/user/freed/utils/qvina02 \
    --starting_smile "c1([*:1])c([*:2])ccc([*:3])c1" \
    --fragmentation crem \
    --num_sub_proc 12 \
    --n_conf 3 \
    --exhaustiveness 8 \
    --save_freq 50 \
    --epochs 200 \
    --commands "evaluate" \
    --reward_version soft \
    --box_center "x1,x2,x3" \
    --box_size "s1,s2,s3" \
    --seed 150 \
    --timeout_dock 90 \
    --timeout_gen3d 30 \
    --name freedpp
```

# Configs

### Table1
Table1 is a part of Table6. Refer to Table6.

### Table2
Table2 is a part of Table7. Refer to Table7.

### Table4
FFREED(ORIG) configs are identical to FFREED, but source code changed according to configs/Tab4/FFREED(ORIG).txt
FFREED configs/Tab6/FFREED
FREED configs/Tab6/FREED

### Table5
configs/Tab5

### Table6
REINVENT configs/Tab5
MolDQN configs/Fig5
FREED configs/Tab6/FREED
Pocket2Mol configs/Tab6/FREED/Pocket2Mol
FFREED configs/Tab6/FFREED
FREED++ configs/Tab6/FREED++

### Table7
N4/CREM_ZINC configs/Tab6/FREED++
Rest configs configs/Tab7

### Table8
FREED++ configs/Tab6/FREED++
FREED++(EXPL) configs are identical to FREED++ except num_epochs_explore=8 and num_epochs_freeze=12, but source code changed according to configs/Tab7/FREED++(EXPL).txt

### Table9
FREED++ configs/Tab6/FREED++
FFREED configs/Tab6/FFREED
FREED++(AM) configs/Tab9/FREED++(AM)
FREED++(PER) configs/Tab9/FREED++(PER)
FREED++(MR) configs/Tab9/FREED++(MR)

### Table10
Source code changed according to configs/Tab10/Time.txt

### Table11
FREED++(vanilla) configs/Tab6/FREED++
FREED++(filtered) configs/Tab11
FREED(vanilla) configs/Tab6/FREED
FREED(filtered) configs are identical to FREED(vanilla), but source code changed according to configs/Tab11/FREED(filtered).txt

### Figure4
configs/Fig4

### Figure5
configs/Fig5

### Figure6
REINVENT configs/Tab5
MolDQN configs/Fig5
FREED configs/Tab6/FREED
FREED++ configs/Tab6/FREED++
FFREED configs/Tab6/FFREED

### Figure7
FREED configs/Fig7/FREED
FREED++ configs/Fig7/FREED++

### Figure8:
configs/Tab7