### SoftPose

1. Environment Setup

   ```
   # create an environment
   conda create -n softpose python=3.8.5
   # activate the created environment
   conda activate softpose
   # recommended pytorch version
   torch==2.1.0+cu121
   torchaudio==2.1.0+cu121
   torchvision==0.16.0+cu121
   # install required packages
   pip install -r requirements.txt
   ```

2. Model and Checkpoints

   Downloading the following checkpoints from the internet and place them in the folder:

   ```
   |-- models
       |-- v1-5-pruned.ckpt  
       |-- higherhrnet_w48_humanart_512x512_udp.pth  
   ```

3. Data

   We trained and evaluated on HumanArt, MHP, and MPII, which can be downloaded from internet. The datasets can be organized in the following format:

   ```
   |-- dataset
       |-- HumanArt
       	 |-- images
       	 |-- pose
       	 |-- mapping_file_training.json
       	 |-- mapping_file_validation.json
       |-- MHP  
       |-- MPII 
   ```

4. Training

   Before training, your need to initialize the model with weights of SD model,

   ```
   python prepare_weights.py models/v1-5-pruned.ckpt configs/soft_pose/humanart_train.yaml models/init_soft_pose.ckpt
   ```

   Start training using the following commands:

   ```
   python train.py --config configs/soft_pose/humanart_train.yaml --max_epochs 10 --control_ckpt models/init_soft_pose.ckpt --devices 4 --scale_lr false
   ```

5. Evaluation

   Start evaluation of pose accuracy and text alignment using the command:

   ```
   python eval_pose.py --config_model configs/soft_pose/humanart_test.yaml --ckpt experiments/soft_pose/run_name/final.pth --scale 7.5
   ```

   Start evaluation of image quality using the command:

   ```
   python eval_quality.py
   ```

   