set -x

export VLLM_ATTENTION_BACKEND=XFORMERS

dapo_path=/ar3po/data/math/dapo-14k.parquet
math500_path=/ar3po/data/math/math500_new.parquet
minerva_math_path=/ar3po/data/math/minerva_math.parquet
olympiad_bench_path=/ar3po/data/math/olympiad_bench.parquet

train_files="['$dapo_path']"
test_files="['$math500_path','$minerva_math_path','$olympiad_bench_path']"

max_prompt_length=1024
# 3072 for qwen, 2048 for other models
max_response_length=3072

project_name='ar3po'
experiment_name='Qwen_7B_ar3po'

cd /ar3po
export PYTHONPATH=.

CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python3 -m verl.trainer.main_ar3po \
    trainer.use_adaptive_rollout=True \
    actor_rollout_ref.model.path=Qwen/Qwen2.5-7B \
    trainer.max_stored_responses=16 \
    trainer.max_per_prompt=8 \
    actor_rollout_ref.rollout.n=4 \
    trainer.reuse_strategy=AK \
    actor_rollout_ref.actor.use_off_policy_training=True \
    algorithm.use_historical_rewards=False \
    algorithm.adv_estimator=grpo \
    data.train_files="$train_files" \
    data.val_files="$test_files" \
    data.train_batch_size=512 \
    data.max_prompt_length=$max_prompt_length \
    data.max_response_length=$max_response_length \
    data.filter_overlong_prompts=True \
    data.truncation='error' \
    actor_rollout_ref.actor.optim.lr=1e-6 \
    actor_rollout_ref.model.use_remove_padding=True \
    actor_rollout_ref.actor.use_dynamic_bsz=True \
    actor_rollout_ref.ref.log_prob_use_dynamic_bsz=True \
    actor_rollout_ref.rollout.log_prob_use_dynamic_bsz=True \
    actor_rollout_ref.actor.ppo_max_token_len_per_gpu=$((max_prompt_length + max_response_length)) \
    actor_rollout_ref.ref.log_prob_max_token_len_per_gpu=$((max_prompt_length + max_response_length)) \
    actor_rollout_ref.rollout.log_prob_max_token_len_per_gpu=$((max_prompt_length + max_response_length)) \
    actor_rollout_ref.actor.ppo_mini_batch_size=128 \
    actor_rollout_ref.actor.use_kl_loss=False \
    actor_rollout_ref.actor.kl_loss_coef=0 \
    actor_rollout_ref.actor.entropy_coeff=0 \
    actor_rollout_ref.model.enable_gradient_checkpointing=True \
    actor_rollout_ref.actor.fsdp_config.param_offload=False \
    actor_rollout_ref.actor.fsdp_config.optimizer_offload=False \
    actor_rollout_ref.rollout.tensor_model_parallel_size=1 \
    actor_rollout_ref.rollout.name=vllm \
    actor_rollout_ref.rollout.gpu_memory_utilization=0.6 \
    actor_rollout_ref.ref.fsdp_config.param_offload=False \
    algorithm.use_kl_in_reward=False \
    trainer.critic_warmup=0 \
    trainer.logger=['console'] \
    trainer.project_name=${project_name} \
    trainer.experiment_name=${experiment_name} \
    trainer.default_local_dir=/instance_storage/${project_name}/${experiment_name} \
    trainer.n_gpus_per_node=8\
    trainer.nnodes=1 \
    trainer.save_freq=27\
    trainer.test_freq=10\
    trainer.val_before_train=False\
    trainer.total_training_steps=270
