
# Scrambled Image Generation using Permutation Matrices

This project includes images of scrambled pixels generated using a **designed permutation matrix** and a **random permutation matrix**. The process can be applied to various datasets such as MNIST, CIFAR-10, Flower, and Imagenet.

## Prerequisites

Ensure you have Python installed along with any necessary dependencies (e.g., PyTorch, numpy, etc.).

## Instructions

### 1. Designed Data

To generate scrambled images using a **designed permutation matrix**, follow these steps:

1. Run the following command to generate the scrambled image:

   ```bash
   python main.py
   ```

2. The default example uses the **MNIST handwritten dataset**. For other datasets, the procedure remains the same. Adjust the settings for different datasets as follows:
   - **Flower** and **Imagenet** datasets:
     - `size = 64`
     - `l = 8`
     - `m = 8`
   - **CIFAR-10** dataset:
     - `size = 32`
     - `l = 8`
     - `m = 4`

### 2. Random Data

To generate scrambled images using a **random permutation matrix**, follow the same steps:

1. Run the following command:

   ```bash
   python main.py
   ```

2. The default example again uses the **MNIST handwritten dataset**, and other datasets can be processed similarly with these adjustments:
   - **Flower** and **Imagenet** datasets:
     - `size = 64`
   - **CIFAR-10** dataset:
     - `size = 32`

## Datasets

- **MNIST**: This dataset is used as the default example.
- **Flower**, **Imagenet**, and **CIFAR-10**: These datasets can be scrambled using the same process with the size and other parameters as mentioned above.

## Note

For convenience, only example data has been retained in this repository. 
## License

This project is licensed under the MIT License. You are free to modify and use it as needed.
