from PIL import Image as I
import numpy as np
import random
import matplotlib.pyplot as plt
import glob
import Random_T as R
import os
from tqdm import tqdm


def read_image(path,size=28):
    img_1=I.open(path).convert("L").resize([size,size])
    img_1=np.array(img_1)
    return img_1

def show(ret):
    plt.imshow(ret)
    plt.show()
    plt.close()
    
def do_one(ret,A):
    ret=np.dot(A,ret)
    ret=np.dot(A,np.transpose(ret,[1,0]))
    return ret
    
def do_one_reverse(ret,T):
    T_=np.linalg.inv(T)   #矩阵求逆
    ret=np.transpose(np.dot(T_,ret),[1,0])
    ret=np.dot(T_,ret)
    return ret
def save(ar,path_):
    ar=ar.astype("uint8")

    img=I.fromarray(ar)
    img.save(path_)
    
if __name__ == "__main__":
    size=28
    l=4
    m=7
    M=R.Random_matrix(size)
    np.savetxt("random_M.txt", M, fmt='%d')
    base_path="../mnist"
    raw_path=os.path.join(base_path,"raw")
    to_path=os.path.join(base_path,"random_transformed")
    os.makedirs(to_path, exist_ok=True)
    file_lst = glob.glob(raw_path + os.path.sep + "**" + os.path.sep + "*", recursive=True)
    for path_ in file_lst:
        if os.path.isfile(path_):
            print("Processing:", path_)
            raw=read_image(path_, size=size)
            change=do_one(raw, M)
            relative_path = os.path.relpath(path_, raw_path)
            to_save = os.path.join(to_path, relative_path)
            os.makedirs(os.path.dirname(to_save), exist_ok=True) 
            save(change, to_save)