# Supplement for moe pack 

Inside this supplement we attach code used to collect stats and run actual experiments.

Also we attach appendix section for our paper under `moe_topology_placement2025_supplement.pdf`

And filled author checklist inder  
`moe_topology_placement2025_checklist.pdf` 

# Collect activations stats

## For DeepSeekMoe~16b model.

```
cd get_deepseek_stats
python3 collect_expert_stats_deepseek.py
```

## For DeepSeek~R1 671B model.

```
cd get_deepseek_stats
python3 vllm_collect_stats_r1.py
```

For reproducibility, we attach stats, used for experiments under:
1. `get_deepseek_stats/16b_1000_0.2` - contains both train and test
2. `get_deepseek_stats/r1_train_100` - contains only train
2. `get_deepseek_stats/r1_test_50` - contains only test

### Scale (Optional)

If you want to simulate custom number of layers or expers per layers,
then you can scale existing ones with patterns from source stats

```
cd get_deepseek_stats
python3 scale_stats.py --raw_routing_data_path ... --activation_matrix_path ... --target_layers ...  --target_experts ...
```

### Split

```
cd get_deepseek_stats
python3 split_stats.py --path_to_raw_routing_data ... --output_dir_prefix ...
```

# Run experiments

### For final results, following commands were used

For single run:

```
./run_experiments.sh ./exp_results ./configs/r1_realistic.yaml ./programs initial_program_simple greedy lpopt_cvx lpopt_load_aware_cvx
```

For grid run over parameters:

```
./run_grid_experiments.sh \
  --results-dir ./final_results \
  --program-folder ./programs \
  --config ./configs/r1_leaf4_one.yaml \
  --topology fat_tree --topology dragonfly --topology dragonfly_sparse --topology fat_tree_2_level \
  --program initial_program_simple --program greedy --program lpopt_cvx --program lpopt_load_aware_cvx  \
  --max-combos 64 \
  --max-procs 64
```

# How to evaluate only one run
```
python3 evaluator.py --config_path configs/... --program_path programs/...
```


For configuration, see __configs/default.yaml__

To run config for program

```
python3 evaluator.py 
--config_path configs/default.yaml 
--program_path programs/lpopt_load_aware.py 
```

# Visualization

To visualize our results and attach final plots, we used code from following files:
1. `paper_prep/draw_stats.ipynb`
2. `paper_prep/parse_results_recovered.ipynb`
