#!/bin/bash
export OMP_NUM_THREADS=1

export CUDA_VISIBLE_DEVICES=0
python3 -u run_baselines.py \
  --env_name starcraft2 \
  --is_smac \
  --sc2_path ~/marl_comms/Multi-Agent-Limited-Comms/3rdparty/StarCraftII \
  --ic3net \
  --nagents 11 \
  --nprocesses 1 \
  --n_rollout_threads 1 \
  --num_epochs 3000 \
  --epoch_size 10 \
  --hid_size 128 \
  --detach_gap 10 \
  --value_coeff 0.01 \
  --lrate 0.0005 \
  --max_steps 100 \
  --recurrent \
  --save \
  --map_name 1o_10b_vs_1r \
  --save \
  --seed 8 \
  --experiment_name IC3Net_SMAC_1o_10b_vs_1r_bench_8 \
  --use_wandb \
  | tee train_smac.log &

export CUDA_VISIBLE_DEVICES=1
python3 -u run_baselines.py \
  --env_name starcraft2 \
  --is_smac \
  --sc2_path ~/marl_comms/Multi-Agent-Limited-Comms/3rdparty/StarCraftII \
  --ic3net \
  --nagents 11 \
  --nprocesses 1 \
  --n_rollout_threads 1 \
  --num_epochs 3000 \
  --epoch_size 10 \
  --hid_size 128 \
  --detach_gap 10 \
  --value_coeff 0.01 \
  --lrate 0.0005 \
  --max_steps 100 \
  --recurrent \
  --save \
  --map_name 1o_10b_vs_1r \
  --save \
  --seed 8 \
  --experiment_name IC3Net_SMAC_1o_10b_vs_1r_bench_12 \
  --use_wandb \
  | tee train_smac.log &

export CUDA_VISIBLE_DEVICES=2
python3 -u run_baselines.py \
  --env_name starcraft2 \
  --is_smac \
  --sc2_path ~/marl_comms/Multi-Agent-Limited-Comms/3rdparty/StarCraftII \
  --ic3net \
  --nagents 11 \
  --nprocesses 1 \
  --n_rollout_threads 1 \
  --num_epochs 3000 \
  --epoch_size 10 \
  --hid_size 128 \
  --detach_gap 10 \
  --value_coeff 0.01 \
  --lrate 0.0005 \
  --max_steps 100 \
  --recurrent \
  --save \
  --map_name 1o_10b_vs_1r \
  --save \
  --seed 8 \
  --experiment_name IC3Net_SMAC_1o_10b_vs_1r_bench_18 \
  --use_wandb \
  | tee train_smac.log &

export CUDA_VISIBLE_DEVICES=3
python3 -u run_baselines.py \
  --env_name starcraft2 \
  --is_smac \
  --sc2_path ~/marl_comms/Multi-Agent-Limited-Comms/3rdparty/StarCraftII \
  --ic3net \
  --nagents 11 \
  --nprocesses 1 \
  --n_rollout_threads 1 \
  --num_epochs 3000 \
  --epoch_size 10 \
  --hid_size 128 \
  --detach_gap 10 \
  --value_coeff 0.01 \
  --lrate 0.0005 \
  --max_steps 100 \
  --recurrent \
  --save \
  --map_name 1o_10b_vs_1r \
  --save \
  --seed 8 \
  --experiment_name IC3Net_SMAC_1o_10b_vs_1r_bench_35 \
  --use_wandb \
  | tee train_smac.log &

export CUDA_VISIBLE_DEVICES=0
python3 -u run_baselines.py \
  --env_name starcraft2 \
  --is_smac \
  --sc2_path ~/marl_comms/Multi-Agent-Limited-Comms/3rdparty/StarCraftII \
  --ic3net \
  --nagents 11 \
  --nprocesses 1 \
  --n_rollout_threads 1 \
  --num_epochs 3000 \
  --epoch_size 10 \
  --hid_size 128 \
  --detach_gap 10 \
  --value_coeff 0.01 \
  --lrate 0.0005 \
  --max_steps 100 \
  --recurrent \
  --save \
  --map_name 1o_10b_vs_1r \
  --save \
  --seed 8 \
  --experiment_name IC3Net_SMAC_1o_10b_vs_1r_bench_41 \
  --use_wandb \
  | tee train_smac.log &