# Optimal Top-Two Method for Best Arm Identification and Fluid Analysis

The general structure of the code (and some functions) is taken from the implementation of Top Two Algorithms Revisited, Jourdan et al., 2022. Reference to this paper is already included in our paper.

**Download packages**
```
julia
using Pkg;
Pkg.add(["Printf", "Distributed", "Optim", "DataFrames"
         "Random", "LinearAlgebra", "Distributions", "CPUTime", "Statistics","Plots"]);
```

## Experiments

After installing Julia, to run the experiments presented in the paper, you can use the custom commands (defined below) to perform a given experiment.

```
cd path_to_folder/code
```

#### Experiments 1
julia -O3 -p4 "Experiment_1/Exp_Dynamics.jl" "Gaussian" "1" "500"
julia -O3 -p4 "Experiment_1/Exp_Dynamics.jl" "Gaussian" "4000" "500"
julia -O3 -p4 "Experiment_1/Exp_Dynamics.jl" "Gaussian" "4000" "2500"

Output files: 
Figure 1: Experiment_1_2/output/4AT2Indexes_Gaussian_500_1.pdf
Figure 3: Experiment_1_2/output/4Arms_Algos_combined_g_Gaussian_500_4000.pdf
Figure 4: Experiment_1_2/output/4Arms_Algos_combined_g_Bernoulli_2500_4000.pdf



#### Experiment 2
julia -O3 -p4 "Experiment_2/Exp_SC_Hard.jl" "Gaussian" "4000"
julia -O3 -p4 "Experiment_2/Exp_SC_Hard.jl" "Bernoulli" "4000"

Output files: 
Figure 5: Experiment_2/output/SC_Gaussian_4000.pdf
Figure 6: Experiment_2/output/SC_Bernoulli_4000.pdf
Tables in these figures are displayed on the terminal.



#### Experiment 3
julia -O3 -p4 "Experiment_3/Exp_SC_delta_Hard.jl" "Gaussian" "4000"
julia -O3 -p4 "Experiment_3/Exp_SC_delta_Hard.jl" "Bernoulli" "4000"

Output files: 
Figure 7: Experiment_3/output/SC_Function_delta_Gaussian_4000.pdf
Figure 8: Experiment_3/output/SC_Function_delta_Bernoulli_4000.pdf



#### Experiment 4
julia -O3 -p4 "Experiment_4/Exp_SC_arms.jl" "Gaussian" "4000"

Output files: 
Figure 9: Experiment_4/output/SC_Function_K_Gaussian_4000.pdf



#### Experiment 5
julia -O3 -p4 "Experiment_5/Exp_runtime.jl" "Gaussian" "4000"

Output: 
Table1: Printed on screen



#### Experiment 6
julia -O3 -p4 "Experiment_6/Exp_SC_alpha_diff.jl" "Gaussian" "100"
julia -O3 -p4 "Experiment_6/Exp_SC_alpha_same.jl" "Gaussian" "100"

Output files: 
Figure 10: Experiment_6/output/SC_alpha_diff_Gaussian_100.pdf
Figure 11: Experiment_6/output/SC_alpha_same_Gaussian_100.pdf



#### Experiment 7
julia -O3 -p4 "Experiment_7/Exp_SC_bdd.jl" "Bdd" "4000"
julia -O3 -p4 "Experiment_7/Exp_SC_Bdd_delta.jl" "Bdd" "4000"

Output files: 
Figure 12: Experiment_7/output/SC_Bdd_4000.pdf
Figure 13: Experiment_7/output/SC_Function_delta_Bdd_4000.pdf
