# Codes from implementation of Top Two Algos. Revisited, Jourdan et al., 2022
# KL divergence for exponential families

# Bernoulli distributions
function dBernoulli(p,q)
  res=0
  if (p!=q)
     if (p<=0) p = eps() end
     if (p>=1) p = 1-eps() end
     res=(p*log(p/q) + (1-p)*log((1-p)/(1-q))) 
  end
  return(res)
end

# Std. Gaussian distribution
function dGaussian(p,q)
  (p-q)^2/2
end

# Poisson distributions
function dPoisson(p,q)
  if (p==0)
     res=q
  else
     res=q-p + p*log(p/q)
  end
  return(res)
end

# Exponential distribution
function dExpo(p,q)
  res=0
  if (p!=q)
     if (p<=0)|(q<=0)
        res=Inf
     else
        res=p/q - 1 - log(p/q)
     end
  end
  return(res)
end