"""
This file is used to take the average of the cold-/warm-start running time and the statistics
such as # of paths taken and average path lengths.
"""

import numpy as np

def mstd(row):
    return (np.mean(row), np.std(row))

groups = ["birdhouse", "head", "shoe", "dog"]
sizes = [30, 60, 120, 240, 480]

time_average_dir = "./sequential_datasets/pr_time_averages.txt"
pr_op_average_dir = "./sequential_datasets/pr_op_averages.txt"
time_average_f = open(time_average_dir, 'w')
pr_op_average_f = open(pr_op_average_dir, 'w')
time_titles = "image_group\tsize\tcold_start\twarm_start\tsaturating_cut\tt_excess\ts_deficit\timprovement\n"
time_average_f.write(time_titles)
pr_op_titles = "image_group\tsize\tcold_pushes\twarm_pushes\tcold_relabels\twarm_relabels\n"
pr_op_average_f.write(pr_op_titles)

for group in groups:
    for size in sizes:
        result_dir = f"./sequential_datasets/{group}_pr_results"
        time_f = open("{}/{}_{}.txt".format(result_dir, size, "time"), 'r')
        push_f = open("{}/{}_{}.txt".format(result_dir, size, "push"), 'r')
        relabel_f = open("{}/{}_{}.txt".format(result_dir, size, "relabel"), 'r')

        time_average_f.write('{}\t{}\t'.format(group, size))
        pr_op_average_f.write('{}\t{}\t'.format(group, size))

        lines = time_f.readlines()[1:]
        lines = [line.split('\t')[1:] for line in lines]
        time_data = np.array(lines, dtype=np.float64)
        time_average = np.average(time_data, axis=0)
        time_std = np.std(time_data, axis=0)

        for i in range(time_average.shape[0]):
            time_average_f.write(str(round(time_average[i], 2)) + '+-' + str(round(time_std[i], 2)) + '\t')
        time_average_f.write(f'{str(round((1 - time_average[1] / time_average[0]) * 100, 2))} += {str(round(100 * time_std[1] / time_average[0], 2))} % + \n')

        pushes = push_f.readlines()[1:]
        pushes = [line.split('\t')[1:3] for line in pushes]
        push_data = np.array(pushes, dtype=np.float64)

        push_average = np.average(push_data, axis=0)
        push_std = np.std(push_data, axis=0)
        pr_op_average_f.write(f'{str(int(push_average[0]))}+={str(int(push_std[0]))}\t')
        pr_op_average_f.write(f'{str(int(push_average[1]))}+={str(int(push_std[1]))}\t')

        relabels = relabel_f.readlines()[1:]
        relabels = [line.split('\t')[1:3] for line in relabels]
        relabel_data = np.array(relabels, dtype=np.float64)

        relabel_average = np.average(relabel_data, axis=0)
        relabel_std = np.std(push_data, axis=0)
        pr_op_average_f.write(f'{str(int(relabel_average[0]))}+={str(int(relabel_std[0]))}\t')
        pr_op_average_f.write(f'{str(int(relabel_average[1]))}+={str(int(relabel_std[1]))}\t\n')

time_average_f.close()
pr_op_average_f.close()








