using Random
using Ranges

indices = randperm(MersenneTwister(1234), 2000)

rates = [500]
d = 10
max_iter = 100
mode = "targeted"  # "untargeted" "targeted-cw"
optim = "joint"  # "univariate"
save = true  # whether or not to save attacked images

test_name = "CVPR24_joint_targeted_ViTB_k-500_d-10_2sam_100iter" #"joint_targeted-cw-test-loss_ResNet50_k-200_d-255_0:50-samples_200-iter"
suffix = "20-sample_100-iter_ViT-B_ICCV25"
n_pixels = 299*299*3  # CHANGE THIS TO 224*224*3 FOR ResNet50, ViT-B or WideResNet)

fw_arguments = (
    line_search=FrankWolfe.MonotonousNonConvexStepSize(),
    max_iteration=max_iter,
    print_iter=max_iter / 10,
    verbose=true,
)
