using Random
using Ranges

indices = randperm(MersenneTwister(1234), 10000)

rates = [10]
d = 255
max_iter = 100
mode = "untargeted"  #"targeted"
optim = "joint" # "joint", "univariate"
save = true
test_name =  "joint_untargeted_test-results_d-255_k-1_100-iter_100-ims_vgg"
suffix = "100-samples_100-iter_vgg"
n_pixels = 32*32*3

fw_arguments = (
    line_search=FrankWolfe.MonotonousNonConvexStepSize(),
    max_iteration=max_iter,
    print_iter=max_iter / 10,
    verbose=true,
)
