### SAIF: Setup and running

We adapt the code from [Interpretable Neural Networks with Frank-Wolfe: Sparse Relevance Maps and Relevance Orderings](https://github.com/ZIB-IOL/fw-rde), which uses the Julia library for Frank Wolfe algorithms [FrankWolfe.jl: A high-performance and flexible toolbox for Frank-Wolfe algorithms and Conditional Gradients](https://github.com/ZIB-IOL/FrankWolfe.jl?tab=readme-ov-file).

## Requirements & Setup

The package versions we used are specified in [`Project.toml`](Project.toml), [`Manifest.toml`](Manifest.toml), and [`setup.jl`](setup.jl).  
To reproduce our computational environment run:

```console
julia setup.jl
```

## Running the code

Tested with cuda 11.3, julia 1.5.3

\<dataset folder name\> can be ImageNet or cifar10.

- Download and copy the ImageNet and CIFAR-10 validation sets under \<dataset folder name\>/data/val

- Carefully review \<dataset folder name\>/config.jl and \<dataset folder name\>/rde.py to make changes for model of choice.

Then, SAIF attack can be generated by running:


    cd FrankWolfe.jl/fw-rde
    julia rde.jl <dataset folder name>
