# setup and activate project environment
using Pkg
Pkg.activate(@__DIR__)

# setup conda environment

Pkg.add("Conda")
using Conda
Conda.add_channel("conda-forge")
Conda.add_channel("nvidia")
Conda.add("cudatoolkit")
Conda.add("cuda-nvcc")
Conda.add("matplotlib")  # =3.1.2
Conda.add("tensorflow-gpu")  # Conda.add("tensorflow-gpu=1.15")
Conda.add("python")  # Conda.add("python=3.7.8")
Conda.add("h5py")  # =2.10.0
Conda.add("pillow") # =8.0.1
Conda.add("numpy")  # =1.17
Conda.add("tqdm")  # =4.53.0
Conda.pip_interop(true)
# Conda.pip("install", "keras-adf==19.1.0")
Conda.pip("install", "vit-keras")
Conda.pip("install", "tensorflow-addons")
Conda.pip("install", "opencv-python")

Pkg.add(url="https://github.com/morgankohler/FrankWolfe.jl", rev="master")
Pkg.add("Ranges")
Pkg.add("JuMP")

# setup pycall and make it use the conda env
ENV["PYTHON"] = ""  # empty path defaults to local conda
Pkg.add("PyCall")



