bot_template_game24='''
from itertools import permutations, product
from sympy import symbols, simplify

def find_solution(numbers):
    ops = '+-*/'
    a, b, c, d = symbols('a b c d')
    for nums in permutations(numbers):
        for op_combination in product(ops, repeat=3):
            expressions = [
                f"(({nums[0]} {op_combination[0]} {nums[1]}) {op_combination[1]} {nums[2]}) {op_combination[2]} {nums[3]}",
                f"({nums[0]} {op_combination[0]} ({nums[1]} {op_combination[1]} {nums[2]})) {op_combination[2]} {nums[3]}",
                f"{nums[0]} {op_combination[0]} (({nums[1]} {op_combination[1]} {nums[2]}) {op_combination[2]} {nums[3]})",
                f"{nums[0]} {op_combination[0]} ({nums[1]} {op_combination[1]} ({nums[2]} {op_combination[2]} {nums[3]}))",
                f"({nums[0]} {op_combination[0]} {nums[1]}) {op_combination[1]} ({nums[2]} {op_combination[2]} {nums[3]})"
            ]

            for expr in expressions:
                if abs(simplify(expr) - 24) < 1e-6:
                    return expr
    return "No solution found."

# Example usage
numbers = [1, 7, 10, 13]
print(find_solution(numbers))
'''



bot_template_checkmate = '''
import chess

def find_checkmate_move(moves_san):
    """
    Find the move that results in checkmate if it exists.
    :param moves_san: A list of chess moves in Standard Algebraic Notation (SAN).
    :return: The move that results in checkmate, or "No checkmate move found".
    """
    # Initialize a new chess board
    board = chess.Board()
    
    # Apply the given moves to the board
    for move_san in moves_san:
        try:
            move = board.parse_san(move_san)
            board.push(move)
        except ValueError:
            return "Invalid move in input"
    
    # Generate all possible legal moves
    for move in board.legal_moves:
        board_copy = board.copy()
        board_copy.push(move)
        
        # Check if the move results in checkmate
        if board_copy.is_checkmate():
            return board.san(move)
    
    return "No checkmate move found"

def preprocess_input(input_str):
    """
    Preprocess the input string by removing move numbers and periods.
    :param input_str: The input string of chess moves.
    :return: A list of preprocessed chess moves.
    """
    moves_san = input_str.split()
    moves_san = [move for move in moves_san if not move.endswith('.')]
    return moves_san

# Example usage
input_str = '1. d4 d5 2. Nf3 Nf6 3. e3 a6 4. Nc3 e6 5. Bd3 h6 6. e4 dxe4 7. Bxe4 Nxe4 8. Nxe4 Bb4+ 9. c3 Ba5 10. Qa4+ Nc6 11. Ne5 Qd5 12. f3 O-O 13. Nxc6 bxc6 14. Bf4 Ra7 15. Qb3 Qb5 16. Qxb5 cxb5 17. a4 bxa4 18. Rxa4 Bb6 19. Kf2 Bd7 20. Ke3 Bxa4 21. Ra1 Bc2 22. c4 Bxe4 23. fxe4 c5 24. d5 exd5 25. exd5 Re8+ 26. Kf3 Rae7 27. Rxa6 Bc7 28. Bd2 Re2 29. Bc3 R8e3+ 30. Kg4 Rxg2+ 31. Kf5'
moves_san = preprocess_input(input_str)
checkmate_move = find_checkmate_move(moves_san)
print(checkmate_move)
'''


bot_template_word_sorting = '''
def sort_words(words):
    """
    Sorts a list of words alphabetically and returns them as a single line of text separated by spaces.

    Args:
    words (list): A list of words to be sorted.

    Returns:
    str: A single line of text with words sorted alphabetically and separated by spaces.
    """
    # Sort the list of words alphabetically
    sorted_words = sorted(words)
    
    # Join the sorted words into a single line of text separated by spaces
    sorted_line = ' '.join(sorted_words)
    
    return sorted_line

# Example usage
input_list = 'thrill splutter panicking scorch same dot prod obstetric malton onus drumhead delmarva barn embezzle it&t damp guru subsist entirety greene'
words_list = input_list.split(' ')
sorted_line = sort_words(words_list)
print(sorted_line)

'''
