
GameOf24 = """
Let's play a game called 24. You'll be given four integers, and your objective is to use each number only once, combined with any of the four arithmetic operations (addition, subtraction, multiplication, and division) and parentheses, to achieve a total of 24. For example, if the input is 4, 7, 8, and 8, the output could be 7 * 8 - 4 * 8 = 24. You only need to find one feasible solution!
Input:
"""
CheckmateInOne = """
Given a series of chess moves written in Standard Algebraic Notation (SAN), determine the next move that will result in a checkmate.
Input: 
"""
WordSorting = """
Sort a list of words alphabetically, placing them in a single line of text separated by spaces.
Input:
"""
P3_Test = """
Given a Python function "sat", the goal is to find an input or a set of inputs that makes "sat" return "True" and then include your input inside a function called "sol()".

For example, if the function was defined like this:

```python
def sat(s: str, t:int):
    return s == "0123456789" and t==10
```

One correct final answer is:

```python
def sol():
    return "0123456789", 10
```

Now, to find a suitable input for a given "sat" function, you need to analyze the function and determine the conditions that make it return "True". Then, put your answer inside the "sol" function with that input as the argument. The final answer should be a self-contained, executable Python code containing only the function, similar to the example above. DO not print the execution results.
"""


distiller_prompt = """

As a highly professional and intelligent expert in information distillation, you excel at extracting essential information to solve problems from user input queries. You adeptly transform this extracted information into a suitable format based on the respective type of the issue. If the problem can be generalized to a higher level to solve multiple issues, further analysis and explanation will be provided upon your next response.
Please categorize and extract the crucial information required to solve the problem from the user's input query. Combining these two elements will generate distilled information. Subsequently, deliver this distilled information, based on the problem type, to your downstream meta planner. The problem type should belong to one of the six categories mentioned above, and the distilled information should include:

1. Values and information of key variables extracted from user input, which will be handed over to the respective expert for task resolution, ensuring all essential information required to solve the problem is provided.
2. The objective of the problem and corresponding constraints.
3. Extend the problem based on 1 and 2, propose a meta problem that can address the user query and handle more input and output variations. Incorporate the real-world scenario of the extended problem along with the types of key variables and information constraints from the original problem to restrict the key variables in the extended problem. After that, use the user query input key information as input to solve the problem as an example.
4. Any code mentioned in the user input query.
5. Your task is to distill the problem, you shouldn't give the final result or possible solution in your respond.

Please distill the information following the format below and cease response after the output of the distilled information.



Meta distiller Respond:


Distilled Information:

1. Key information:

2. Restriction: (It should be noted that the answer should strictly follow the real-world rule such as in arithmatic equation, the Priority of operator, the need of parentheses etc. So according to the distilled information, emphasize the real-world rules that need to be followed within the problem.)

3. Distilled task:

4. Codes mentioned in the query: (Optional)

5. Answer form: (Optional, skip when there is no specific answer form)

  **Note: The generation ends here. Do not show this message in your answer !**
  
"""

general_distilled = """
Distilled Information:

1. Key information:

2. Restriction:

3. Distilled task:

4. Code mentioned in the query:

5. Answer form:
"""

general_code_template = """
from itertools import permutations, product # used for enumberating the possible cases, for example:
#    for nums in permutations(numbers):
#        for combination in product(ops, repeat=3):
from sympy import simplify # used for evaluating the expression
import chess # all chess apis, for example:
# board = chess.Board()
# board.parse_san(move_san)
# board.push(move)
# board.is_checkmate()
# board.san(move)

def sol(numbers):
    # return some results
    return [1, 2, 3, 4]
"""

initial_vdb_content = {
  "solution_templates": {
    "documents": [general_distilled],
    "metadatas": [{"keywords": "solvable by codes;", "template": general_code_template}]
  },
}

instantiation_prompt = """
You are an expert in problem analysis and can apply previous problem-solving approaches to new issues.
The user will provide a specific task description and a thought template. Your goal is to analyze the user's task and generate a specific solution based on the thought template.
If the instantiated solution involves Python code, only provide the code and let the compiler handle it. If the solution does not involve code, provide a final answer that is easy to extract from the text.
The code should just provide a function `sol` which is the solution.
It should be noted that all the python code should be within one code block, the answer should not include more than one code block! And strictly follow the thought-template to instantiate the python code but you should also adjust the input parameter according to the user input! The number and type of output should also strictly follow provided information!
Make sure the code is executable and includes all necessary packages.
* NOTE: Just provide the function definition of `sol`, and don't call this function!
* NOTE: Do not contain `sat` code!
"""

combined_input_template = """
Distilled information:
{distilled_question}
User Input:
{question}
Thought template:
{template}

Instantiated Solution:
Please analyze the above user task description and thought template, and generate a specific, detailed solution. If the solution involves Python code, provide the function definition of `sol`. If not, provide a clear and extractable final answer.        
"""

verification_prompt = """
You are an expert in problem analysis and can apply previous problem-solving approaches to new issues.
The user will provide a specific task description. Your goal is to analyze the user's task and generate a specific piece of procedure that verifies whether an answer satisfy user's task.
If user's task already include the verification/satisfaction procedure, or `sat` function code, just use it!
If the instantiated solution involves Python code, only provide the code and let the compiler handle it. If the solution does not involve code, provide a step-by-step procedure that is easy to extract from the text.
The code should just provide a function `sat` which is the satisfaction function.
It should be noted that all the python code should be within one code block, the answer should not include more than ONE code block in markdown! And strictly follow the thought-template to instantiate the python code but you should also adjust the input parameter according to the user input! The number and type of output should also strictly follow provided information!
Make sure the code is correct and includes all necessary packages.
* NOTE: Only rovide the function definition of `sat`! don't call the `sat` function!
* NOTE: Don't provide solution or `sol` function to the user's task!
"""

combined_verification_template = """
Distilled information:
{distilled_question}
User Input:
{question}

Suppose I already have a solution to the above user's task. Generate a satisfaction procedure as defined here:

Satisfaction:
Output the verification/satisfaction procedure.
If it is code, only output the `sat` function! e.g.
```python
def sat(numbers):
    return True
```
Use the `sat` function directly if is provided.
"""
verification_prompt2 = """
You are an expert in problem analysis and can apply previous problem-solving approaches to new issues.
The user will provide a specific task description and a piece of code (with function name `sat`) for checking the correctness.
Your goal is to generate a specific example input to the function `sat`.
It should be noted that all the python code should be within one code block, the answer should not include more than ONE code block in markdown! The number and type of output should strictly follow provided information!
Make sure the code is correct and includes all necessary packages.
* NOTE: Only extend the code of `sat` by adding the print code of the executing the example.
* NOTE: You should never include a `sol` function in it, and only use a defined variable as the execution example!
"""

combined_verification_template2 = """
Distilled information:
{distilled_question}
User Input:
{question}
SAT Code:
{sat_code}

Next, suppose I already have a solution to the above user's task. Help me test the SAT code with a sample input you generated.
Just extend the give SAT code, and only return one code block with printing the SAT result (True/False).

e.g.
```python
def sat(numbers):
    return True
print(sat([1, 2, 3]))
```
Don't add a `sol` function!
"""

code_debug_prompt = """
You are an excellent python programming master who are proficient in analyzing and editing python code, and you are also good at understanding the real-world problem. Your task is:
1. Analyze the given python code
2. Analyze the code execution result given by user, and give the reaons of logical problems (answer incorrect) or programming errors (errors occurred)
2. Edit the input code to make sure the edited code is correct and could run and solve the problem correctly.  
Your respond should follow the format below:
```python
## Edited code here
```
* NOTE: Just provide the function definition of `sol`, and don't call this function!
"""

code_debug_template = """
Problem description: {question}

The code solution, but with logical problems or programming errors:
{code}

The result of code execution: {result}

Fix the function `sol` in the code:
"""

code_error_prompt = """
You are an excellent python programming master who are proficient in analyzing and editing python code, and you are also good at understanding the real-world problem. Your task is:
1. Analyze the given python code
2. Analyze the code execution result given by user, and give the reaons programming errors (errors occurred)
2. Edit the input code to make sure the edited code has no error while maintaining its logic.
Your respond should follow the format below:
```python
## Edited code here
```
* NOTE: debug the function `sat`!
"""

code_error_template = """
The code with programming errors:
{code}

The result of code execution: {result}

Fix the function `sat` in the code:
"""


new_template_prompt = """
As a highly professional and intelligent expert in problem extraction and solution analyzer, you should help on analyze the user questions and a working solution, and judge whether the working solution has been modified to improve the template solution to better solve the problem.
Here is the template solution:

{template}

* Note: just answer YES or NO.
"""

new_template_format = """
Given the problem and the working solution:

# Problem:

{distilled_question}


# Solution:

{solution}

* Whether the solution is modifed to fit the problem, based on the template solution? Just answer YES or NO
"""


need_exec_system = """
You are an assistant that check the user's request and a suggested code solution, and see whether there is a need to execute the code to get the answer to user's question or the answer is already is the code.
Return "YES" if need execution, or return the code as the answer
"""

need_exec_user = """
The user question: {distilled_question}

Code Solution:
{code}

Whether we need to execute the code? if not return the code directly to the user:
"""

result_solution_system = """
As an assistant that deliver the final result from another assistant to the user.
Given the user query and servel generated outputs from the other assistant, select the result that is required by the user and deliver it.
Direct output only the result of your selection, without speaking anything.
"""

result_solution_user = """
The user question: {distilled_question}

Outputs from the other assistant:
Output1:
{result}
Output1:
{code}

Select the result requirent by the user and deliver it directly:
"""