
GameOf24 = """
Let's play a game called 24. You'll be given four integers, and your objective is to use each number only once, combined with any of the four arithmetic operations (addition, subtraction, multiplication, and division) and parentheses, to achieve a total of 24. For example, if the input is 4, 7, 8, and 8, the output could be 7 * 8 - 4 * 8 = 24. You only need to find one feasible solution!
Input:
"""
CheckmateInOne = """
Given a series of chess moves written in Standard Algebraic Notation (SAN), determine the next move that will result in a checkmate.
Input: 
"""
WordSorting = """
Sort a list of words alphabetically, placing them in a single line of text separated by spaces.
Input:
"""
P3_Test = """
Given a Python function "sat", the goal is to find an input or a set of inputs that makes "sat" return "True" and then include your input inside a function called "sol()".

For example, if the function was defined like this:

```python
def sat(s: str, t:int):
    return s == "0123456789" and t==10
```

One correct final answer is:

```python
def sol():
    return "0123456789", 10
```

Now, to find a suitable input for a given "sat" function, you need to analyze the function and determine the conditions that make it return "True". Then, put your answer inside the "sol" function with that input as the argument. The final answer should be a self-contained, executable Python code containing only the function, similar to the example above. DO not print the execution results.
"""


distiller_prompt = """

As a highly professional and intelligent expert in information distillation, you excel at extracting essential information to solve problems from user input queries. You adeptly transform this extracted information into a suitable format based on the respective type of the issue. If the problem can be generalized to a higher level to solve multiple issues, further analysis and explanation will be provided upon your next response.
Please categorize and extract the crucial information required to solve the problem from the user's input query. Combining these two elements will generate distilled information. Subsequently, deliver this distilled information, based on the problem type, to your downstream meta planner. The problem type should belong to one of the six categories mentioned above, and the distilled information should include:

1. Values and information of key variables extracted from user input, which will be handed over to the respective expert for task resolution, ensuring all essential information required to solve the problem is provided.
2. The objective of the problem and corresponding constraints.
3. Extend the problem based on 1 and 2, propose a meta problem that can address the user query and handle more input and output variations. Incorporate the real-world scenario of the extended problem along with the types of key variables and information constraints from the original problem to restrict the key variables in the extended problem. After that, use the user query input key information as input to solve the problem as an example.
4. Any code mentioned in the user input query.
5. Your task is to distill the problem, you shouldn't give the final result or possible solution in your respond.

Please distill the information following the format below and cease response after the output of the distilled information.



Meta distiller Respond:


Distilled Information:

1. Key information:

2. Restriction: (It should be noted that the answer should strictly follow the real-world rule such as in arithmatic equation, the Priority of operator, the need of parentheses etc. So according to the distilled information, emphasize the real-world rules that need to be followed within the problem.)

3. Distilled task:

4. Codes mentioned in the query: (Optional)

5. Answer form: (Optional, skip when there is no specific answer form)

  **Note: The generation ends here. Do not show this message in your answer !**
  
"""

general_distilled = """
Distilled Information:

1. Key information:

2. Restriction:

3. Distilled task:

4. Code mentioned in the query:

5. Answer form:
"""

general_code_template = """
from itertools import permutations, product # used for enumberating the possible cases, for example:
#    for nums in permutations(numbers):
#        for combination in product(ops, repeat=3):
from sympy import simplify # used for evaluating the expression
import chess # all chess apis, for example:
# board = chess.Board()
# board.parse_san(move_san)
# board.push(move)
# board.is_checkmate()
# board.san(move)

def sol(numbers):
    # return some results
    return [1, 2, 3, 4]

def sat(inputs):
    return sum(inputs) == 10 # return a bool to check whether the inputs meet the requirements

# Evaluate
answer = sol([1, 2])
print("Answer:")
print(answer)
print("SAT:")
print(sat(answer))
"""

initial_vdb_content = {
  "solution_templates": {
    "documents": [general_distilled],
    "metadatas": [{"keywords": "solvable by codes;", "template": general_code_template}]
  },
}

instantiation_prompt = """
You are an expert in problem analysis and can apply previous problem-solving approaches to new issues.
The user will provide a specific task description and a thought template. Your goal is to analyze the user's task and generate a specific solution based on the thought template.
If the instantiated solution involves Python code, only provide the code and let the compiler handle it. If the solution does not involve code, provide a final answer that is easy to extract from the text.
The code should contain at least two functions. One is `sol` which is the solution, and another is `sat` which is for checking whether the result of `sol` statisfy the user's problem. Put the satisfaction code at the end, e.g.:

def sol(...):
    ... # sat is not called inside it
def sat(...):
    ... # sol is not called inside it
answer = sol()
print("Answer:")
print(answer)
print("SAT:")
print(sat(answer))

It should be noted that all the python code should be within ONE code block! And strictly follow the thought-template to instantiate the python code but you should also adjust the input parameter according to the user input! The number and type of output should also strictly follow provided information!
Make sure the code is executable and includes all necessary packages.
* NOTE: never call `sat` function inside `sol` and vice versa!
* NOTE: never call `sol` function inside `sat`!
* NOTE: copy the `sat` code directly if it is provided by the user.
"""

combined_input_template = """
Distilled information:
{distilled_question}
User Input:
{question}
Thought template:
{template}

Instantiated Solution:
Please analyze the above user task description and thought template, and generate a specific, detailed solution. If the solution involves Python code, provide the code including solution function `sol` and satisfaction function `sat`. If not, provide a clear and extractable final answer.        
"""

code_debug_prompt = """
You are an excellent python programming master who are proficient in analyzing and editing python code, and you are also good at understanding the real-world problem. Your task is:
1. Analyze the given python code and the result;
2. Figure out whether the code is logically wrong (SAT=False) or programming wrong (errors occurred);
3. Edit the input code to make sure the edited code is logically correct and able to run.
Your respond should follow the format below:
```python
## Edited code here
```
* NOTE: never call `sat` function inside `sol`!
* NOTE: never call `sol` function inside `sat`!
* NOTE: don't edit `sat` function! `sat` is like an oracle.
"""

code_verification_template = """
User_input: {question}
Code: {code}
The result of code execution: {result}

Fix the function `sol` in the code, don't modify any other code, don't call `sat`:
"""


new_template_prompt = """
As a highly professional and intelligent expert in problem extraction and solution analyzer, you should help on analyze the user questions and a working solution, and judge whether the working solution has been modified to improve the template solution to better solve the problem.
Here is the template solution:

{template}

* Note: just answer YES or NO.
"""

new_template_format = """
Given the problem and the working solution:

# Problem:

{distilled_question}


# Solution:

{solution}

* Whether the solution is modifed to fit the problem, based on the template solution? Just answer YES or NO
"""


need_exec_system = """
You are an assistant that check the user's request and a suggested code solution, and see whether there is a need to execute the code to get the answer to user's question or the answer is already is the code.
Return "YES" if need execution, or return the code as the answer
"""

need_exec_user = """
The user question: {distilled_question}

Code Solution:
{code}

Whether we need to execute the code? if not return the code directly to the user:
"""

result_solution_system = """
As an assistant that deliver the final result from another assistant to the user.
Given the user query and servel generated outputs from the other assistant, select the result that is required by the user and deliver it.
Direct output only the result of your selection, without speaking anything.
"""

result_solution_user = """
The user question: {distilled_question}

Outputs from the other assistant:
Output1:
{result}
Output1:
{code}

Select the result requirent by the user and deliver it directly:
"""