
GameOf24 = """
Let's play a game called 24. You'll be given four integers, and your objective is to use each number only once, combined with any of the four arithmetic operations (addition, subtraction, multiplication, and division) and parentheses, to achieve a total of 24. For example, if the input is 4, 7, 8, and 8, the output could be 7 * 8 - 4 * 8 = 24. You only need to find one feasible solution!
Input:
"""
CheckmateInOne = """
Given a series of chess moves written in Standard Algebraic Notation (SAN), determine the next move that will result in a checkmate.
Input: 
"""
WordSorting = """
Sort a list of words alphabetically in ascending order.
e.g. "bell abandon critus" to "abandon bell critus".
Do not split up the original words.
It's ok not to change the order if it is already correct.

Input:
"""
P3_Test = """
Given a Python function "sat", the goal is to find an input or a set of inputs that makes "sat" return "True" and then include your input inside a function called "sol()".

For example, if the function was defined like this:

```python
def sat(s: str, t:int):
    return s == "0123456789" and t==10
```

One correct final answer is:

```python
def sol():
    return "0123456789", 10
```

Now, to find a suitable input for a given "sat" function, you need to analyze the function and determine the conditions that make it return "True".
Then, put your answer inside the "sol" function with that input as the argument.
The final answer should be a self-contained, executable Python code containing only the function, similar to the example above.
DO not print the execution results in the `sol` function.
* NOTE: `sol` should not take any arguments and only return a single output, not a tuple. The output is used to feed to the first argument of `sat`, other arguments use default values.
* NOTE: `sol` should never return None, instead using assertions for edge cases.
* NOTE: do not call `sat` inside `sol`.
"""
Sonnet = "",

distiller_prompt = """

As a professional and intelligent expert in information distillation, you excel at extracting essential information from user input queries into the following format. Don't give the solution, instead, focusing on how to distill the key information and thoughts of this specific problem.

Distilled Information For Solving the Problem:

1. Problem definition: analysis specific that are the key information to solve the problem.

2. Details of the problem: details of the information, code analysis.

3. Input names and types, output types for the solution code.

4. Difficulty: Analyze the difficulty of the problem using the details of the problem, what potential problem could the a programmer have in their code? Give the difficulty detail and specific to the user's specific question.

5. Answer code format.
"""

general_code_template = """
def sol(numbers):
    # return some results
    return [1, 2, 3, 4]
"""

#It should be noted that you should provide 2 different ways of writing python codes to solve the same problem.
#Each code should be within one code block. You should provide two code blocks within ```python``` blocks.
instantiation_prompt = """
You are an expert in problem analysis and can apply previous problem-solving approaches to new issues.
The user will provide a specific task description and a thought template. Your goal is to analyze the user's task and generate a specific solution based on the thought template.
If the instantiated solution involves Python code, only provide the code and let the compiler handle it. If the solution does not involve code, provide a final answer that is easy to extract from the text.
The code should just provide a function `sol` which is the solution.

The code should be in only one markdown code block (```python```).

Make sure the code is executable and includes all necessary packages.
* NOTE: Just provide the function definition of `sol`, and don't call this function!
* NOTE: Do not contain `sat` code!

* NOTE: use `assert [condition], messages` during each step of the `sol` code to write a test-driven code.
"""

#Please analyze the above user task description and thought template, and generate two piece of code inside TWO separate ```python``` blocks, each block should contain the function definition of `sol`. DO NOT use `sat` function in `sol`.
combined_input_template = """
Distilled information:
{distilled_question}

User Input:
{question}

Thought template:
{template}

Instantiated Solution:
Please analyze the above user task description and thought template, and generate one piece of code inside a ```python``` blocks, the block should contain the function definition of `sol`. DO NOT use `sat` function in `sol`.
"""

generate_debug_distiller = """
As a professional and intelligent expert in information distillation, you excel at extracting essential information from user input queries into the following format. Don't give the solution, instead, focusing on how to distill the key information and thoughts of this specific problem.
The user has tried coding on his own, but get errors when executing it, analyze the difficulty of the problem.

Distilled Information For Solving the Problem:

1. Problem definition: analysis specific that are the key information to solve the problem.

2. Details of the problem: details of the information, code analysis.

3. Input names and types, output types for the solution code.

4. Difficulty: Analyze the difficulty of the problem using the details of the problem, what potential problem could the a programmer have in their code? Give the difficulty detail and specific to the user's specific question.

5. Previous Code:

6. Previous Code error, and possible reasons:

* Note: the error are normally generated by assertions, which are required for the debugging using the messages of the failed assertions.
"""
debug_prompt = "User Question:\n{distilled_question}\n\nPrevious Code:\n{code}\n\nError Message of Previous Code:\n{err_msg}"
