# -*- coding: utf-8 -*-
"""

"""



import argparse
from time import sleep
from concurrent.futures import ThreadPoolExecutor, as_completed
import json
import os
from queue import Queue
import logging

import sys
import threading
import time
import random
from typing import get_args
import chatbot.models.duplex_model_with_stream_asr as duplex
from chatbot.utils.arg_utils import set_args
from chatbot.utils.llm_utils import reset_messages

from chatbot.utils.tts_utils import Speaker
from chatbot.utils.asr_utils import Listener
from chatbot.utils.realtime_asr_utils import ASR_RESULT_QUEUE
EMPTY_AUDIO_DATA = b"\xf3\xff\xfe\xff\xf4\xff\xed\xff\xf6\xff\xf2\xff\xf7\xff\r\x00\x0c\x00\x02\x00\xfd\xff\x01\x00\xff\xff\x02\x00\x03\x00\x0c\x00\xff\xff\xf5\xff\xf7\xff\xf3\xff\xeb\xff\xe1\xff\xed\xff\xee\xff\xf2\xff\xea\xff\xf0\xff\xf3\xff\xef\xff\xff\xff\x0b\x00\x03\x00\x05\x00\x11\x00\x12\x00\x08\x00\x08\x00\x0c\x00\x08\x00\t\x00\t\x00\r\x00\x11\x00\x18\x00\x14\x00\x13\x00\x1c\x00\x15\x00\x0e\x00\x0b\x00\t\x00\n\x00\x02\x00\x0b\x00\x17\x00\x13\x00\x07\x00\x03\x00\x07\x00\xfd\xff\x03\x00\x06\x00\xf1\xff\xf5\xff\xf4\xff\xf6\xff\xea\xff\xec\xff\xf0\xff\xe6\xff\xe3\xff\xe2\xff\xda\xff\xe6\xff\xfc\xff\xfc\xff\xf8\xff\xff\xff\x05\x00\x00\x00\xf7\xff\xf2\xff\x00\x00\x01\x00\x02\x00\x0e\x00\x14\x00\x16\x00\x1a\x00%\x00\x1b\x00\x0e\x00\x1a\x00\x16\x00\x0b\x00\n\x00\x0b\x00\x0f\x00\x10\x00\x10\x00\x10\x00\n\x00\x11\x00\x11\x00\x0e\x00\x16\x00\x10\x00\x02\x00\xfb\xff\xfd\xff\xfc\xff\x03\x00\xfc\xff\xf5\xff\xfa\xff\x05\x00\x12\x00\n\x00\xfb\xff\xfc\xff\xf5\xff\xe8\xff\xe2\xff\xd6\xff\xd3\xff\xe9\xff\xfb\xff\xfc\xff\n\x00\xf9\xff\xef\xff\xf1\xff\xec\xff\xfd\xff\x00\x00\xfe\xff\x00\x00\x03\x00\x05\x00\x07\x00\x04\x00\x03\x00\x03\x00\x08\x00\x04\x00\x08\x00\x05\x00\x0f\x00\x17\x00\x1e\x00\x1f\x00\x15\x00\x14\x00\x11\x00\x12\x00\x0b\x00\x00\x00\xfe\xff\xfc\xff\xf0\xff\xe9\xff\xe0\xff\xf0\xff\xfd\xff\xec\xff\xf5\xff\xf3\xff\xf4\xff\xfc\xff\xf3\xff\xf9\xff\xff\xff\x05\x00\xfd\xff\xf3\xff\xfa\xff\xf8\xff\xef\xff\xeb\xff\xf1\xff\xf3\xff\xeb\xff\xec\xff\xf1\xff\xf3\xff\xfe\xff\t\x00\x05\x00\xee\xff\xeb\xff\xf2\xff\xf5\xff\xf6\xff\xf0\xff\xeb\xff\xe9\xff\xe6\xff\xe7\xff\xf9\xff\xf9\xff\xf5\xff\xeb\xff\xf3\xff\xf2\xff\xfb\xff\xf7\xff\xff\xff\x00\x00\x05\x00\x12\x00\x16\x00\x1f\x00\x1b\x00\x1d\x00\x1e\x00\x15\x00\r\x00\x10\x00$\x00+\x00\x19\x00\x15\x00\x18\x00\x14\x00\x0f\x00\t\x00\x15\x00\x06\x00\x05\x00\x15\x00\x1b\x00\x18\x00\r\x00\x0b\x00\x03\x00\x01\x00\x00\x00\xf8\xff\xfc\xff\n\x00\x12\x00\x0e\x00\xef\xff\xf2\xff\xee\xff\xf5\xff\xfb\xff\xf5\xff\xfa\xff\xfb\xff\xfb\xff\xfb\xff\xee\xff\xf1\xff\xfa\xff\x04\x00\x03\x00\x08\x00\xfe\xff\xf6\xff\xf7\xff\xf2\xff\xe5\xff\xd8\xff\xe4\xff\xf0\xff\xff\xff\xf8\xff\x06\x00\x14\x00\x13\x00\x1b\x00\x1d\x00\x12\x00\x14\x00\n\x00\x12\x00\x0e\x00\x17\x00\x1b\x00\x12\x00\x17\x00\x0c\x00\x05\x00\x05\x00\x08\x00\xfa\xff\xfc\xff\xff\xff\xf6\xff\xf9\xff\xee\xff\xec\xff\xef\xff\xf2\xff\xf4\xff\xed\xff\xf0\xff\xf3\xff\xf4\xff\xf1\xff\xef\xff\xf4\xff\xed\xff\xe2\xff\xfc\xff\x00\x00\x03\x00\x08\x00\x15\x00\x0f\x00\x03\x00\xfe\xff\xf7\xff\xfe\xff\xfc\xff\x02\x00\x08\x00\x01\x00\xff\xff\x03\x00\xf3\xff\xf8\xff\xff\xff\x02\x00\xfa\xff\xef\xff\xf4\xff\xe9\xff\xdf\xff\xd9\xff\xda\xff\xdb\xff\xdf\xff\xe5\xff\xe0\xff\xf9\xff\xf9\xff\n\x00\x04\x00\xff\xff\x0f\x00\x1b\x00'\x00\x16\x00%\x00%\x00&\x00.\x00%\x00(\x00#\x00+\x00\x1c\x00\x1a\x00\x14\x00\x0b\x00\r\x00\r\x00\t\x00\n\x00\x08\x00\x05\x00\x08\x00\x07\x00\r\x00\x07\x00\xf8\xff\xf2\xff\xf6\xff\xeb\xff\xf6\xff\xf2\xff\xe9\xff\xec\xff\xe7\xff\xf0\xff\xfa\xff\xf2\xff\xf2\xff\xff\xff\xf3\xff\xeb\xff\xeb\xff\xe7\xff\xe7\xff\xee\xff\xec\xff\xee\xff\xf6\xff\xe9\xff\xe4\xff\xe8\xff\xf9\xff\xf8\xff\xf9\xff\xff\xff\x01\x00\x10\x00\x16\x00\xfe\xff\x01\x00\x08\x00\x01\x00\x02\x00\x0b\x00\x18\x00\x17\x00\x16\x00\x17\x00\x0e\x00\x0e\x00\x13\x00\x18\x00\x1f\x00\x10\x00\n\x00\xff\xff\xf8\xff\xfc\xff\x00\x00\xf5\xff\xf5\xff\x02\x00\xfe\xff\xfb\xff\xf1\xff\xe7\xff\xe9\xff\xea\xff\xe1\xff\xdb\xff\xdd\xff\xe6\xff\xee\xff\xec\xff\xef\xff\xeb\xff\xfa\xff\xfe\xff\xf7\xff\x05\x00\x05\x00\x0c\x00\x02\x00\x05\x00\x15\x00!\x00\x15\x00\x1e\x00&\x00#\x00\x1b\x00\x0f\x00\x14\x00\t\x00\x19\x00\x10\x00\x0b\x00\x08\x00\x0c\x00\r\x00\t\x00\r\x00\x0e\x00\x19\x00\x19\x00\x0f\x00\x0e\x00\r\x00\x07\x00\xff\xff\xff\xff\xfd\xff\xf7\xff\xf9\xff\t\x00\x11\x00\x00\x00\xf9\xff\xfd\xff\xf9\xff\xf3\xff\xf2\xff\xfd\xff\n\x00\x0e\x00\t\x00\x0c\x00\r\x00\xfd\xff\xe7\xff\xf2\xff\xe7\xff\xdd\xff\xee\xff\xe4\xff\xeb\xff\xeb\xff\xed\xff\xed\xff\xe6\xff\xec\xff\xfb\xff\xfc\xff\xf5\xff\xf5\xff\xf0\xff\xef\xff\xf5\xff\xf3\xff\xfa\xff\x06\x00\xff\xff\x03\x00\x07\x00\x0e\x00\r\x00\x0e\x00\x04\x00\x07\x00\x0b\x00\xfd\xff\xfd\xff\xf6\xff\xff\xff\x0c\x00\xff\xff\xf8\xff\x00\x00\x02\x00\x01\x00\x06\x00\x08\x00\xf9\xff\xfa\xff\x0c\x00\x11\x00\x16\x00\x16\x00\x0e\x00\x10\x00\x16\x00\x0c\x00\t\x00\x0b\x00\xfd\xff\t\x00\xfb\xff\xf9\xff\x04\x00\n\x00\r\x00\x03\x00\x0b\x00\xfe\xff\xff\xff\xf6\xff\xf1\xff\xfe\xff\xfb\xff\x01\x00\xf4\xff\xf4\xff\xf3\xff\xf3\xff\x04\x00\x01\x00\xfd\xff\xf4\xff\xf5\xff\xf6\xff\xf2\xff\xe7\xff\xd9\xff\xe0\xff\xe5\xff\xf3\xff\x03\x00\x01\x00\xfe\xff\xfb\xff\xff\xff\x06\x00\x07\x00\x01\x00\xfb\xff\xfc\xff\xf6\xff\xf7\xff\x00\x00\xfc\xff\xf3\xff\x05\x00\x05\x00\x00\x00\xfb\xff\xe8\xff\xf5\xff\xe6\xff\xec\xff\xee\xff\xef\xff\xf6\xff\xf3\xff\x02\x00\x06\x00\x13\x00\x18\x00\x19\x00&\x00 \x00*\x000\x000\x00-\x00,\x00*\x00&\x00\x19\x00\x17\x00\x1a\x00\x18\x00\x13\x00\x03\x00\x05\x00\n\x00\x05\x00\xfc\xff\xfe\xff\xf8\xff\xee\xff\xec\xff\xdb\xff\xd6\xff\xdc\xff\xe2\xff\xe7\xff\xe0\xff\xdf\xff\xe0\xff\xdb\xff\xf4\xff\xf9\xff\xf6\xff\xf8\xff\xf3\xff\xfa\xff\xfb\xff\xff\xff\x00\x00\xf8\xff\xf4\xff\xee\xff\xec\xff\xf2\xff\xf5\xff\xfa\xff\xfd\xff\xff\xff\xfd\xff\xfb\xff\xfd\xff\x07\x00\x06\x00\n\x00\x12\x00\x0e\x00\x0c\x00\x07\x00\x0c\x00\n\x00\x06\x00\x06\x00\x03\x00\xf3\xff\xf1\xff\xeb\xff\xee\xff\x02\x00\x07\x00\n\x00\x1b\x00\x1f\x00\x19\x00\x1a\x00\x1b\x00\x0f\x00\x0c\x00\x14\x00\x18\x00\x1e\x00\x1a\x00!\x00!\x00\x15\x00\x0f\x00\t\x00\x14\x00\x13\x00\x03\x00\n\x00\x12\x00\x17\x00\n\x00\x06\x00\x01\x00\xff\xff\x04\x00\x05\x00\t\x00\x01\x00\x06\x00\x08\x00\xff\xff\xff\xff\x05\x00\x07\x00\xf9\xff\xf6\xff\xf7\xff\x00\x00\t\x00\xfe\xff\xef\xff\xf2\xff\xee\xff\xf1\xff\xf5\xff\xe7\xff\xee\xff\xec\xff\xe9\xff\xdd\xff\xda\xff\xde\xff\xd9\xff\xec\xff\xef\xff\xec\xff\xe2\xff\xec\xff\xec\xff\xe8\xff\xf6\xff\xf0\xff\xf2\xff\xf7\xff\xf1\xff\xea\xff\xf2\xff\xf8\xff\xfa\xff\xf8\xff\x03\x00\x05\x00\xfe\xff\x10\x00\x10\x00\x06\x00\x03\x00\xfd\xff\xeb\xff\xf0\xff\xf2\xff\xf2\xff\xf3\xff\x04\x00\n\x00\x11\x00\x0e\x00\n\x00\n\x00\x0c\x00\x10\x00\xf7\xff\xf4\xff\xf3\xff\x03\x00\t\x00\x0c\x00\x07\x00\x0c\x00\r\x00\xff\xff\n\x00\x0c\x00\x10\x00\x12\x00\x17\x00\x08\x00\xfe\xff\xfc\xff\xf8\xff\x02\x00\xfd\xff\xfc\xff\n\x00\n\x00\n\x00\x0e\x00\t\x00\x0b\x00\r\x00\x02\x00\x06\x00\x01\x00\x01\x00\n\x00\xff\xff\x05\x00\x07\x00\x18\x00\x19\x00\x17\x00\x11\x00\x12\x00\r\x00\x02\x00\x01\x00\x05\x00\x01\x00\xfd\xff\xfe\xff\xf6\xff\xfe\xff\x08\x00\x0b\x00\x08\x00\x01\x00\xff\xff\x06\x00\x08\x00\x0f\x00\x07\x00\xf9\xff\xf8\xff\xf0\xff\xf2\xff\xf1\xff\xe7\xff\xf4\xff\x03\x00\x08\x00\x0e\x00\r\x00\x01\x00\xf6\xff\x04\x00\x00\x00\x0b\x00\t\x00\x00\x00\xff\xff\x04\x00\xf9\xff\xfc\xff\x06\x00\x07\x00\x0c\x00\x02\x00\xf8\xff\xf3\xff\xf2\xff\xf6\xff\xf8\xff\xf7\xff\xfb\xff\x01\x00\xfe\xff\xfb\xff\x00\x00\x04\x00\x06\x00\xf9\xff\xef\xff\xe8\xff\xe9\xff\xe6\xff\xf0\xff\xfe\xff\xf7\xff\xf8\xff\xf6\xff\xf4\xff\xf5\xff\xf7\xff\xfb\xff\xfa\xff\xeb\xff\xf1\xff\x01\x00\xf7\xff\xf5\xff\xf1\xff\xf6\xff\xed\xff\xe2\xff\xec\xff\xf4\xff\xff\xff\xf6\xff\xf5\xff\xfa\xff\x01\x00\x0c\x00\n\x00\x06\x00\x0c\x00\x00\x00\x00\x00\x10\x00\x0b\x00\t\x00\x14\x00\x16\x00\x18\x00\x1c\x00\x19\x00\x1d\x00\x18\x00\x10\x00\x10\x00\x16\x00\r\x00\xfb\xff\xfd\xff\x01\x00\xfa\xff\x07\x00\n\x00\xff\xff\x00\x00\x06\x00\xff\xff\xfc\xff\x04\x00\x08\x00\x00\x00\xf7\xff\xf3\xff\xfe\xff\t\x00\xfe\xff\x04\x00\xf5\xff\xfb\xff\xfc\xff\x00\x00\x07\x00\x07\x00\x17\x00\x12\x00\x17\x00\x11\x00\x15\x00\x18\x00\x17\x00\t\x00\x00\x00\x01\x00\xfd\xff\xfe\xff\xfc\xff\x04\x00\t\x00\x03\x00\xfa\xff\xf4\xff\x08\x00\x03\x00\x01\x00\xf4\xff\xe9\xff\xe5\xff\xe5\xff\xee\xff\xec\xff\xe2\xff\xe4\xff\xf2\xff\xe7\xff\xed\xff\xf2\xff\xfc\xff\xff\xff\xf5\xff\x0f\x00\r\x00\x03\x00\xfc\xff\xf5\xff\xfb\xff\xee\xff\xf4\xff\xf0\xff\xef\xff\xf8\xff\xf9\xff\xf9\xff\x03\x00\x10\x00\x13\x00\x0e\x00\x12\x00\x17\x00\t\x00\x00\x00\x02\x00\x04\x00\xfe\xff\xf9\xff\xf9\xff\xfc\xff\xfe\xff\xfc\xff\x02\x00\x0c\x00\x0c\x00\x06\x00\x10\x00\x10\x00\x01\x00\x10\x00"


from loguru import logger


speaker = Speaker()
licenser = Listener()

play_audio_queue = Queue()
record_audio_queue = Queue()

user_query_queue = Queue()
asr_audio_queue = ASR_RESULT_QUEUE
# asr_audio_queue = Queue()
llm_query_queue = Queue()
llm_answer_queue = Queue()
replay_text_queue = Queue()

run_event = threading.Event()
force_stop_play_audio_event = threading.Event()
start_record_audio_event = threading.Event()
start_input_audio_event = threading.Event()
stop_record_audio_event = threading.Event()
force_stop_record_audio_event = threading.Event()
reset_process_audio_event = threading.Event()

play_audio_queue_lock = threading.Lock()
record_audio_queue_lock = threading.Lock()

benchmark_record_queue = Queue()


def read_objs4jsonl_file(file_path):
    with open(file_path, "r", encoding="utf-8") as reader:
        for line in reader:
            yield json.loads(line)


def read_audio(audio_id, audio_home):
    with open(os.path.join(audio_home, f"{audio_id}.wav"), "rb") as reader:
        return reader.read()


def input_process(sample_path, audio_home):
    logger.info(f"input_process begin")
    samples = list(read_objs4jsonl_file(sample_path))
    random.seed(1024)
    samples = random.sample(samples, 20)
    for sample in samples:
        if not run_event.is_set():
            return
        reset_messages()
        for i, conv in enumerate(sample["messages"]):
            if not run_event.is_set():
                return
            if conv["role"] != "user":
                continue
            audio_data = read_audio(conv["_id"], audio_home)
            
            logger.info("wait start_input_audio_event")
            while not start_input_audio_event.is_set():
                record_audio_queue.put(EMPTY_AUDIO_DATA)
                sleep(0.5)
            
            logger.info("get start_record_audio_event")
            stop_record_audio_event.clear()
            benchmark_record_queue.put({"type": "conversation start", "sample_id": sample["id"], "conv": conv, "total": len(audio_data), "time_stamp": time.time()})

            
            piece_time = 0.160
            piece_len = int(piece_time * 16000 * 2) 
            
            while audio_data:
                record_audio_queue.put(audio_data[:piece_len])
                sleep(piece_time)
                audio_data = audio_data[piece_len:]
                if stop_record_audio_event.is_set():
                    break
            benchmark_record_queue.put({"type": "conversation stop", "sample_id": sample["id"], "conv": conv, "left": len(audio_data), "time_stamp": time.time()})
            start_input_audio_event.clear()
            stop_record_audio_event.clear()
            sleep(1.0)
    
    logger.info(f"input_process finished")


def output_process():
    while run_event.is_set():
        while play_audio_queue.empty() or play_audio_queue_lock.locked():
            sleep(0.1)
            if not run_event.is_set():
                return
        done = 0
        while not play_audio_queue.empty():
            with play_audio_queue_lock:
                audio_data, text_data = play_audio_queue.get()
            if audio_data:
                benchmark_record_queue.put({"type": "play", "text_data": text_data, "length": len(audio_data), "time_stamp": time.time()})
                done += len(audio_data)
                if done < 44000:
                    sleep(len(audio_data) / 44000)
                else:
                    sleep(len(audio_data) / 44000 / 4)
            if text_data:
                if not audio_data:
                    benchmark_record_queue.put({"type": "play", "text_data": text_data, "length": 0, "time_stamp": time.time()})
                replay_text_queue.put(text_data.strip())
        cnt = 0
        while play_audio_queue.empty():
            sleep(0.1)
            cnt += 1
            if play_audio_queue.empty() and cnt > 40:
                force_stop_record_audio_event.set()
                force_stop_play_audio_event.set()
                stop_record_audio_event.set()
                sleep(5)
                logger.info("start_input_audio_event is set!")
                start_input_audio_event.set()
                break
    logger.info("output_process exit")


def record_process(record_path):
    with open(record_path, "w", encoding="utf-8") as writer:
        while run_event.is_set():
            if not benchmark_record_queue.empty():
                record = benchmark_record_queue.get()
                logger.info(f"record: {record}")
                writer.write(json.dumps(record, ensure_ascii=False))
                writer.write("\n")
                writer.flush()
    logger.info("record_process exit")



def exit(run_event,
         force_stop_play_audio_event,
         start_record_audio_event,
         stop_record_audio_event,
         force_stop_record_audio_event,
         start_input_audio_event):
    run_event.clear()
    force_stop_play_audio_event.set()
    start_record_audio_event.set()
    stop_record_audio_event.set()
    force_stop_record_audio_event.set()
    start_input_audio_event.set()

def main():
    args = get_args()
    set_args(args)
    
    run_event.set()
    
    input_func = (input_process, {"audio_home": args.audio_data_dir, "sample_path": args.benchmark_sample_path})
    output_func = (output_process, {})
    record_func = (record_process, {"record_path": args.record_result_path})
    
    run_event.set()
    
    input_func = (input_process, {})
    output_func = (output_process, {})
    record_func = (record_process, {})
    
    test_funcs = [
             (duplex.process_audio_record, {"licenser":licenser, 
                                    "record_audio_queue":record_audio_queue, 
                                    "record_audio_queue_lock":record_audio_queue_lock, 
                                    "start_record_audio_event":start_record_audio_event, 
                                    "run_event":run_event, 
                                    "force_stop_play_audio_event":force_stop_play_audio_event,
                                    "stop_record_audio_event":stop_record_audio_event,
                                    "asr_audio_queue":asr_audio_queue, 
                                    "reset_process_audio_event": reset_process_audio_event}), 
             (duplex.stop_play_audio, {"force_stop_play_audio_event":force_stop_play_audio_event, 
                                "play_audio_queue_lock":play_audio_queue_lock, 
                                "play_audio_queue": play_audio_queue, 
                                "start_record_audio_event":start_record_audio_event, 
                                "run_event": run_event}), 
             (duplex.stop_record_audio, {"force_stop_record_audio_event":force_stop_record_audio_event, 
                                "stop_record_audio_event":stop_record_audio_event, 
                                "record_audio_queue":record_audio_queue, 
                                "asr_audio_queue":asr_audio_queue, 
                                "start_record_audio_event":start_record_audio_event,
                                "run_event":run_event,
                                "llm_query_queue": llm_query_queue,
                                "llm_answer_queue": llm_answer_queue,
                                "reset_process_audio_event": reset_process_audio_event,}),
             (duplex.asr_process, {"asr_audio_queue":asr_audio_queue, 
                            "llm_query_queue":llm_query_queue, 
                            "run_event":run_event}), 
             (duplex.llm_process, {"llm_query_queue":llm_query_queue, 
                            "llm_answer_queue":llm_answer_queue, 
                            "run_event":run_event, 
                            "replay_text_queue": replay_text_queue, 
                "force_stop_play_audio_event": force_stop_play_audio_event,
                "force_stop_record_audio_event": force_stop_record_audio_event,
                "benchmark_record_queue": benchmark_record_queue}), 
             (duplex.tts_process, {"llm_answer_queue":llm_answer_queue, 
                            "play_audio_queue": play_audio_queue, 
                            "run_event": run_event,
                            "stream_tts": args.stream_tts})]
    with ThreadPoolExecutor(max_workers=16) as pool:
        futures = [pool.submit(func[0], **func[1]) for func in [output_func, record_func, *test_funcs]]
        future = pool.submit(input_func[0], **input_func[1])
        try:
            start_input_audio_event.set()
            while True:
                time.sleep(1)
                if future.done():
                    break
            logger.info(f"Input func finished!")
            sleep(60)
            logger.info(f"begin to clear")
            exit(run_event=run_event,
                    force_stop_play_audio_event=force_stop_play_audio_event,
                    start_record_audio_event=start_record_audio_event,
                    stop_record_audio_event=stop_record_audio_event,
                    force_stop_record_audio_event=force_stop_record_audio_event,
                    start_input_audio_event=start_input_audio_event)
        except KeyboardInterrupt as e:
            logger.info(f"Bye!")
            exit(run_event=run_event,
                force_stop_play_audio_event=force_stop_play_audio_event,
                start_record_audio_event=start_record_audio_event,
                stop_record_audio_event=stop_record_audio_event,
                force_stop_record_audio_event=force_stop_record_audio_event,
                start_input_audio_event=start_input_audio_event)
            sys.exit(-1)


if __name__ == '__main__':
    print("Begin")
    # input_process()
    main()
    print("End")
