import time
import json
import wave
import uuid
from scipy import signal
from queue import Queue


URL = ""

def set_realtime_asr_url(url):
    global URL
    URL = url
    

CLIENT = ""


ASR_RESULT_QUEUE = Queue()

def slice_data(data, chunk_size):
    data_len = len(data)
    offset = 0
    while offset + chunk_size < data_len:
        yield data[offset: offset + chunk_size]
        offset += chunk_size
    else:
        yield data[offset: data_len]


class RealTimeASR():
    def __init__(self, url, token=""):
        self.url = url
        self.token = token
        self.client = RealTimeClient(
            url=self.url,
            token=token,
            req_id=uuid.uuid4().hex,
            nbest=1,
            on_start=self.test_on_start,
            on_sentence_changed=self.test_on_sentence_changed,
            on_sentence_end=self.test_on_sentence_end,
            on_completed=self.test_on_completed,
            on_error=self.test_on_error
        )
        self.last = ""
    
    def reset(self):
        print("reset realtime asr")
        self.last = ""
        self.client.close()
        self.client = RealTimeClient(
            url=self.url,
            token=self.token,
            req_id=uuid.uuid4().hex,
            nbest=1,
            on_start=self.test_on_start,
            on_sentence_changed=self.test_on_sentence_changed,
            on_sentence_end=self.test_on_sentence_end,
            on_completed=self.test_on_completed,
            on_error=self.test_on_error
        )

    def test_on_start(self, message, **_kwargs):
        print("test_on_start: {}".format(message))

    def test_on_sentence_changed(self, message, result, **_kwargs):
        print("test_on_chg: {}. Result: {}".format(message, json.dumps(result, ensure_ascii=False)))
        print("push into ASR_RESULT_QUEUE")
        ASR_RESULT_QUEUE.put(self.last + result[0]['sentence'])

    def test_on_sentence_end(self, message, result, **_kwargs):
        global final_result
        print("test_on_sentence_end: {}. Result: {}".format(message, json.dumps(result, ensure_ascii=False)))
        if len(result[0]['sentence']) > 0:
            final_result += result[0]['sentence'] + '。'
        self.last += result[0]['sentence'] + '。 '

    def test_on_completed(self, message, *args):
        print("on_completed: {}".format(message))

    def test_on_error(self, message, *args):
        print("on_error: {}".format(message))
        self.reset()
        
    def send_audio(self, audio_data):
        self.client.send(audio_data)

    def send(self, file_path):
        with wave.open(file_path, 'rb') as wave_fp:
            nchannels, sampwidth, framerate, nframes = wave_fp.getparams()[:4]
            wave_bytes = wave_fp.readframes(nframes)
        
        assert framerate == 16000 and sampwidth == 2, "Only support 16K 16bit wav"

        chunk_size = 0.160
        num_bytes = int(chunk_size * 16000 * 2)
        index = 0
        while index < len(wave_bytes):
            self.client.send(wave_bytes[index:index + num_bytes])
            index += num_bytes
            time.sleep(0.001)
        self.client.stop()

    def close(self):
        self.client.close()


def setup_realtime_asr_client():
    global CLIENT
    CLIENT = RealTimeASR(URL, token="")


def send_audio_data(audio_data):
    global CLIENT
    CLIENT.send_audio(audio_data)
    
def reset_asr_record():
    global CLIENT
    CLIENT.reset()


if __name__ == '__main__':
    file_path = "wav file path"
    client = RealTimeASR(URL, token="")
    client.send(file_path)
    client.close()
    print('results:\n{}'.format(final_result))
