# Neural Characteristic Flow (NCF) for Optimal Transport

This repository contains the official implementation of our optimal transport model using neural networks and characteristics of Hamilton-Jacobi (HJ) equations. This code was used to generate the results in our paper.

---

## Requirements

Please ensure the following Python packages are installed:

    # Base environment
    python>=3.8
    torch>=1.12
    numpy
    pyhocon
    tqdm
    matplotlib

Additionally, for color transfer, please install and import the following libraries:

    pillow
    opencv-python
    
---

## Usage

1. **Clone the repository** and navigate to the project directory.

2. **Prepare your dataset files** in `.npy` format inside a data folder.

3. **Modify the configuration file** (`setup.conf`) to adjust hyperparameters and training settings as needed.

4. **Run the training script** with the appropriate arguments:

    python run.py --home_dir path/to/home --conf path/to/setup.conf --data_dir path/to/data --input input_data.npy --output output_data.npy --gpu 0
