# Improving Intrinsic Exploration by Creating Stationary Objectives

This is the code for the paper Improving Intrinsic Exploration by Creating Stationary Objectives.

A supplementary website for the project is available [here](https://sites.google.com/view/augmented-agents-iclr2024/home)

TLDR: We propose a state augmentation that enables better exploration policies. We augment count-based methods and E3B. 

![](augmented_exploration.gif)

# Installation
```
conda create -n aug-agents python=3.8
pip install -r requirements.txt
pip install -e .
```
# Running Augmented Count-based Methods

All the relevant code is in:
```
cd countbased/
```
You can run experiments on mazes with:
```
python <algorithm>.py --total-timesteps 15000000 --savedir <your directory> --maze-id <1,2 or 3> 
```
where <algorithm> can be ppo, a2c, dqn and ppo_lstm.

You can run experiments on a 3D map with (only on a Linux machine):
```
python <algorithm>.py --total-timesteps 50000000 --savedir <your directory> 
```

# Running Augmented E3B

All the instructions are available in:

```
cd e3b/
```