Install dependencies for Minihack and Procgen

Using sudo:
```
sudo apt-get install -y build-essential autoconf libtool pkg-config python3-dev python3-pip python3-numpy git flex bison libbz2-dev

wget -O - https://apt.kitware.com/keys/kitware-archive-latest.asc 2>/dev/null | sudo apt-key add -
sudo apt-add-repository 'deb https://apt.kitware.com/ubuntu/ bionic main'
sudo apt-get update && apt-get --allow-unauthenticated install -y cmake kitware-archive-keyring
```

Using conda (no need of sudo access)
```
conda config --add channels conda-forge
conda config --set channel_priority strict
conda install cmake flex bison bzip2
conda install -c conda-forge cxx-compiler

conda install _sysroot_linux-64_curr_repodata_hack _sysroot_linux-aarch64_curr_repodata_hack _sysroot_linux-ppc64le_curr_repodata_hack _sysroot_linux-s390x_curr_repodata_hack kernel-headers_linux-64 kernel-headers_linux-aarch64 kernel-headers_linux-ppc64le kernel-headers_linux-s390x sysroot-conda_2_28-aarch64 sysroot-conda_2_28-ppc64le sysroot-conda_2_28-s390x sysroot-conda_2_28-x86_64 sysroot_linux-64 sysroot_linux-aarch64 sysroot_linux-ppc64le sysroot_linux-s390x

cd e3b/minihack/torchbeast
pip install -r requirements.txt
```

To train an agent with augmented matrix run:

For Minihack:
```
OMP_NUM_THREADS=1 python main.py  --learning_rate 0.0001 --model e3b-aug --episodic_bonus_type elliptical-icm --savedir ./results/elliptical-aug/ --env MiniHack-MultiRoom-N6-v0 --ridge 0.1 --reward_norm int --intrinsic_reward_coef 1.0 --seed 1
```

ProcGen:
```
OMP_NUM_THREADS=1 python main.py  --learning_rate 0.0001 --model e3b-aug --episodic_bonus_type elliptical-icm --savedir ./results/elliptical-aug/ --env procgen-maze-memory --ridge 0.1 --reward_norm int --intrinsic_reward_coef 1.0 --seed 1
```

