import gym
import numpy as np
from gym import ObservationWrapper
from gym.spaces import Box
from griddly import gd
from IPython import embed

class MazeEnv(gym.Wrapper):
    def __init__(self, **kwargs):
        
        env = gym.make("GDY-_MazeEnv-v0",
                       level=0,
                       player_observer_type=gd.ObserverType.VECTOR,
                       global_observer_type=gd.ObserverType.VECTOR,
                       **kwargs)
        
        self.observation_space = env.observation_space
        self.action_space = env.action_space

        super(MazeEnv, self).__init__(env)

    def step(self, action):
        self.t += 1
        return super().step(action)
    
    def reset(self):
        print("reset at step", self.t)
        return super().reset()

    def render(self, mode="rgb_array"):
        return super().render(mode)