clear
clc

load Jacobian.mat;
load Snap.mat;

n_sta = 2000;

n_sam_all = [3,4,5,6,7,8,9,10,12,14,15]; n_n_sam_all = length(n_sam_all);
sigma_all = [0.01,0.325]; n_sigma = length(sigma_all);


kappa_est_sta_all = cell(n_sigma,n_n_sam_all);
kappa_est_sta_median_all = cell(n_sigma,n_n_sam_all);
kappa_est_sta_bar_all = cell(n_sigma,n_n_sam_all);

cor_prob = zeros(n_sigma,n_n_sam_all);

for i_sigma=1:n_sigma

for i_n_sam=1:n_n_sam_all

n_g = 19;
n_sam = n_sam_all(i_n_sam);
n_all = length(Snap1(1,:));
n_dim = length(A1(:,1));
covD = zeros(n_dim,n_dim); 
for i=1:n_dim
    covD(i,i) = 0.01;
end

A_r =  A19;
[U_r,L_r] = eig(A_r);
W_r = pinv(U_r');
L_r_diag = real(diag(L_r));
L_r_diag_max = max(L_r_diag);
index_r_max = find(L_r_diag==L_r_diag_max);
index_r_max = index_r_max(1);
vd_r = real(U_r(:,index_r_max));
wd_r = real(W_r(:,index_r_max));
kappa_r = vd_r.*wd_r;
kappa_r = kappa_r/norm(kappa_r);


covC_r = lyap(A_r,covD);


n_ite = 1;

kappa_est_sta = zeros(n_dim,n_sta);

n_cor = 0;

for i_sta=1:n_sta

Ker_data = [];
Data_all = [];
% nums = 1:n_sam;
nums = randperm(n_all,n_sam);
kappa_est_ite = zeros(n_dim,n_ite);
error_est_ite = zeros(n_ite,1);
for i_ite=1:n_ite
tic
for k=1:n_g
    % nums = randperm(n_all,n_sam);
    if k<n_g
        % nums = randperm(n_all,n_sam);
        eval(sprintf('Snap_%d_mean = transpose(mean(transpose(Snap%d)));', k, k));
        eval(sprintf('Snap_%d_x = Snap%d - Snap_%d_mean;', k, k, k));
        eval(sprintf('S_k = [Snap_%d_x(:,nums);zeros(1,n_sam) + (k/n_g - 0.5)*2];', k));
        eval(sprintf('Data_k = Snap_%d_x(:,nums);', k));
    else
        % nums = randperm(n_all,n_sam);
        eval(sprintf('Snap_r_mean = transpose(mean(transpose(Snap%d)));', n_g));
        eval(sprintf('Snap_r_x = Snap%d - Snap_r_mean;', n_g));
        S_k = [Snap_r_x(:,nums);zeros(1,n_sam) + (k/n_g - 0.5)*2];
        Data_k = Snap_r_x(:,nums);
    end
    Ker_data = [Ker_data,S_k];
    Data_all = [Data_all,Data_k];
end

Ker_max = max(max(Data_all));
Ker_min = min(min(Data_all));
% if n_sam>10
%     sigma = sigma_all(i_sigma)*3/n_sam;
% else
%     sigma = sigma_all(i_sigma);
% end
sigma = sigma_all(i_sigma);

Ker_data_norm = Ker_data;

Ker_data_norm(1:n_dim,:) = ((Ker_data_norm(1:n_dim,:) - Ker_min)/(Ker_max - Ker_min) - 0.5)*2;

Weight = zeros(1,n_g*n_sam);

for i=1:n_g*n_sam
    S_i = [Ker_data_norm(1:n_dim,i);1;];
    error_vec_i = (S_i - Ker_data_norm).*(S_i - Ker_data_norm);
    norm_vec_i = sum(error_vec_i); 
    norm_exp_vec_i = exp(-0.5*norm_vec_i/sigma^2)/sigma/(sqrt(2*pi)^(n_dim+1));
    Weight(i) = sum(norm_exp_vec_i);
end
Weight = Weight/sum(Weight);

covC_r_est = covC_r*0;

for i=1:n_g*n_sam
    covC_r_est = covC_r_est + Weight(i) * (Ker_data(1:n_dim,i)*Ker_data(1:n_dim,i)');
end
covC_r_est = covC_r_est/5;

A_vec = vec_X(A_r);
index_0 = find(A_vec==0);
index_n0 = find(A_vec~=0);
A_vec_n0 = A_vec(index_n0);
index_positive = find(A_vec_n0>0);
index_negtive = find(A_vec_n0<0);
n_0 = length(index_0);

D = covD;

C_use = covC_r_est;
fun = @(z)cost_Lyap(z,index_n0,n_dim,D,C_use);
noncon = @(z)circlecon(z,index_positive,index_negtive);
z0(index_positive) = rand(1,length(index_positive));
z0(index_negtive) = -rand(1,length(index_negtive));
% [zs,fval] = fmincon(fun,z0,[],[],[],[],[],[],noncon);
[zs,fval] = fmincon(fun,z0,[],[],[],[],[],[],[]);
z_aug = zeros(n_dim^2,1);
z_aug(index_n0) = zs';
A_bar = zeros(n_dim,n_dim);
for i=1:n_dim
    A_bar(:,i) = z_aug((i-1)*n_dim+1:i*n_dim);
end

[U_bar,L_bar] = eig(A_bar);
W_bar = pinv(U_bar');
L_bar_real_diag = real(diag(L_bar));
L_bar_real_diag_max = max(L_bar_real_diag);
index_bar_max = find(L_bar_real_diag==L_bar_real_diag_max);
index_bar_max = index_bar_max(1);
vd_bar = real(U_bar(:,index_bar_max));
wd_bar = real(W_bar(:,index_bar_max));
kappa_bar = vd_bar.*wd_bar;
toc
i_sigma
i_n_sam
i_sta
i_ite
kappa_est_ite(:,i_ite) = kappa_bar;
% error_est_ite(i_ite) = norm(kappa_bar - kappa_r);
error_est_ite(i_ite) = fval;
% error_est_ite(i_ite) = norm(A_bar-A_r);
end
error_est_ite_min = min(error_est_ite);
index_est_sta = find(error_est_ite==error_est_ite_min);
index_est_sta = index_est_sta(1);
kappa_est_sta(:,i_sta) = kappa_est_ite(:,index_est_sta);
kappa_est_sta(:,i_sta) = kappa_est_sta(:,i_sta)/norm(kappa_est_sta(:,i_sta));


kappa_est_sta_i = kappa_est_sta(:,i_sta);
kappa_est_sta_i_max = max(kappa_est_sta_i);

index_sta_i_max = find(kappa_est_sta_i==kappa_est_sta_i_max);
if index_sta_i_max==5
    n_cor = n_cor + 1;
elseif index_sta_i_max==10
    n_cor = n_cor + 1;
end

end

cor_prob(i_sigma,i_n_sam) = n_cor/n_sta;

ds = 0.01;
kappa_interval = -1:ds:1;
len_interval = length(kappa_interval);
node_index = 1:n_dim;
kappa_est_fre = zeros(len_interval,n_dim);

kappa_est_sta_mean = zeros(n_dim,1);
kappa_est_sta_std = zeros(n_dim,1);
kappa_est_sta_median = zeros(n_dim,1);
kappa_est_sta_bar = zeros(n_dim,1);
alpha = 0.95;

bar_min = 0.01; bar_max = 1;
n_bi = 30;

for i_dim=1:n_dim
    kappa_est_sta_mean(i_dim) = mean(kappa_est_sta(i_dim,:));
    kappa_est_sta_median(i_dim) = median(kappa_est_sta(i_dim,:));
    kappa_est_sta_std(i_dim) = std(kappa_est_sta(i_dim,:));
    bar_mid = (bar_max + bar_min)/2;
    kappa_est_sta_i_dim = kappa_est_sta(i_dim,:);
    for i_bi=1:n_bi
        idx = find(kappa_est_sta_i_dim >= kappa_est_sta_median(i_dim)-bar_mid & kappa_est_sta_i_dim <= kappa_est_sta_median(i_dim) + bar_mid);
        alpha_est = length(idx)/length(kappa_est_sta_i_dim);
        if alpha_est<alpha
            bar_min = bar_mid;
        else
            bar_max = bar_mid;
        end
        bar_mid = (bar_max + bar_min)/2;
    end
    kappa_est_sta_bar(i_dim) = bar_mid;

   for i_interval=1:len_interval 
        kappa_est_i_dim = kappa_est_sta(i_dim,:);
        kappa_error_i_dim = abs(kappa_est_i_dim - kappa_interval(i_interval));
        index_error_i_dim = find(kappa_error_i_dim<=ds/2);
        kappa_est_fre(i_interval,i_dim) = length(index_error_i_dim);
    end
    kappa_est_fre(:,i_dim) = kappa_est_fre(:,i_dim)/norm(kappa_est_fre(:,i_dim));
end

kappa_est_sta_all{i_sigma,i_n_sam} = kappa_est_sta;
kappa_est_sta_median_all{i_sigma,i_n_sam} = kappa_est_sta_median;
kappa_est_sta_bar_all{i_sigma,i_n_sam} = kappa_est_sta_bar;

end




end

n_sam_choose = [2,length(n_sam_all)];

figure(1)
subplot(1,3,1)
index = 1:1:19;
eigen_max = zeros(19,1);
eigen_dom = zeros(19,1);
for k=1:n_g
    eval(sprintf('A_r = A%d;', k));  
    [U_r,L_r] = eig(A_r);
    W_r = pinv(U_r');
    L_r_diag = real(diag(L_r));
    L_r_diag_max = max(L_r_diag);
    covC_r = lyap(A_r,covD);
    eval(sprintf('Snap_%d_mean = transpose(mean(transpose(Snap%d)));', k, k));
    eval(sprintf('Snap_%d_x = Snap%d - Snap_%d_mean;', k, k, k));
    eval(sprintf('Data_k = Snap_%d_x(:,1:5);', k));
    covC_r_est = Data_k*Data_k';
    [Uc_r,Lc_r] = eig(covC_r);
    Lc_r_diag = real(diag(Lc_r));
    Lc_r_diag_max = max(Lc_r_diag);
    eigen_max(k) = L_r_diag_max;
    eigen_dom(k) = Lc_r_diag_max;
end
[ax,h1,h2] = plotyy(index, eigen_max, index, eigen_dom);
% Labeling
xlabel('Time index $k$','Interpreter','Latex');
ylabel(ax(1), 'Maximal eigenvalue ($A$)' ,'Interpreter','Latex');
ylabel(ax(2), 'Dominant eigenvalue ($C_{est}$)' ,'Interpreter','Latex');

% Optional: line styles
set(h1, 'LineStyle','--',  'Color','b', 'LineWidth',2, 'Marker','o', 'MarkerSize',6);
set(h2, 'LineStyle','--', 'Color','r', 'LineWidth',2, 'Marker','s', 'MarkerSize',6);
title('(a) Indicator' ,'Interpreter','Latex');
set([ax(1), ax(2)], 'FontSize',16, 'FontName','Times New Roman');
grid on


subplot(1,3,2)
plot(kappa_r,'-vk','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(1)}-kappa_est_sta_bar_all{1,n_sam_choose(1)},'--or','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(1)}-kappa_est_sta_bar_all{2,n_sam_choose(1)},'-.sb','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(1)}+kappa_est_sta_bar_all{1,n_sam_choose(1)},'--or','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(1)}+kappa_est_sta_bar_all{2,n_sam_choose(1)},'-.sb','LineWidth',2)
hold off
title('(b) Confidence bound $N=5$','Interpreter','Latex')
legend('Real','SOTA','Proposed','Interpreter','Latex')
xlabel('Node index $i$','Interpreter','Latex')
ylabel("$w_{d}(i)v_{d}(i)$",'Interpreter','Latex')
set(gca,'FontSize',16,'fontname','Times New Roman')
xlim([0,11])
ylim([-2,2])
grid on

subplot(1,3,3)
plot(kappa_r,'-vk','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(2)}-kappa_est_sta_bar_all{1,n_sam_choose(2)},'--or','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(2)}-kappa_est_sta_bar_all{2,n_sam_choose(2)},'-.sb','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(2)}+kappa_est_sta_bar_all{1,n_sam_choose(2)},'--or','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(2)}+kappa_est_sta_bar_all{2,n_sam_choose(2)},'-.sb','LineWidth',2)
hold off
title('(c) Confidence bound $N=15$','Interpreter','Latex')
legend('Real','SOTA','Proposed','Interpreter','Latex')
xlabel('Node index $i$','Interpreter','Latex')
ylabel("$w_{d}(i)v_{d}(i)$",'Interpreter','Latex')
set(gca,'FontSize',16,'fontname','Times New Roman')
xlim([0,11])
ylim([-2,2])
grid on

figure(2)
% Statistical analysis of node estimation accuracy. Results of 2,000 trials are reported.
plot(n_sam_all/n_dim,cor_prob(1,:)*100,'--or','LineWidth',2)
hold on
plot(n_sam_all/n_dim,cor_prob(2,:)*100,'--sb','LineWidth',2)
hold off
title('(d) Reg. node estimation','Interpreter','Latex')
xlabel('$N/2n$','Interpreter','Latex')
ylabel("Accuracy [$\%$]",'Interpreter','Latex')
set(gca,'FontSize',16,'fontname','Times New Roman')
xlim([0,1.7])
ylim([0,100])
grid on


save results_gaussian_plot;