clear
clc

load results_gaussian_plot;

figure(1)
subplot(1,4,1)
index = 1:1:19;
eigen_max = zeros(19,1);
eigen_dom = zeros(19,1);
for k=1:n_g
    eval(sprintf('A_r = A%d;', k));  
    [U_r,L_r] = eig(A_r);
    W_r = pinv(U_r');
    L_r_diag = real(diag(L_r));
    L_r_diag_max = max(L_r_diag);
    covC_r = lyap(A_r,covD);
    eval(sprintf('Snap_%d_mean = transpose(mean(transpose(Snap%d)));', k, k));
    eval(sprintf('Snap_%d_x = Snap%d - Snap_%d_mean;', k, k, k));
    eval(sprintf('Data_k = Snap_%d_x(:,1:5);', k));
    covC_r_est = Data_k*Data_k';
    [Uc_r,Lc_r] = eig(covC_r);
    Lc_r_diag = real(diag(Lc_r));
    Lc_r_diag_max = max(Lc_r_diag);
    eigen_max(k) = L_r_diag_max;
    eigen_dom(k) = Lc_r_diag_max;
end
[ax,h1,h2] = plotyy(index, eigen_max, index, eigen_dom);
% Labeling
xlabel('Time index $k$','Interpreter','Latex');
ylabel(ax(1), 'Maximal eigenvalue ($A$)' ,'Interpreter','Latex');
ylabel(ax(2), 'Dominant eigenvalue ($C_{est}$)' ,'Interpreter','Latex');

% Optional: line styles
set(h1, 'LineStyle','--',  'Color','b', 'LineWidth',2, 'Marker','o', 'MarkerSize',6);
set(h2, 'LineStyle','--', 'Color','r', 'LineWidth',2, 'Marker','s', 'MarkerSize',6);
title('(a) Indicator' ,'Interpreter','Latex');
set([ax(1), ax(2)], 'FontSize',16, 'FontName','Times New Roman');
grid on


subplot(1,4,2)
plot(kappa_r,'-vk','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(1)}-kappa_est_sta_bar_all{1,n_sam_choose(1)},'--or','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(1)}-kappa_est_sta_bar_all{2,n_sam_choose(1)},'-.sb','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(1)},'-r','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(1)},'-b','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(1)}+kappa_est_sta_bar_all{1,n_sam_choose(1)},'--or','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(1)}+kappa_est_sta_bar_all{2,n_sam_choose(1)},'-.sb','LineWidth',2)
hold off
title('(b) Confidence bound $N=5$','Interpreter','Latex')
legend('Real','SOTA (Boud)','Proposed (Bound)','SOTA (Median)','Proposed (Median)','Interpreter','Latex')
xlabel('Node index $i$','Interpreter','Latex')
ylabel("$w_{d}(i)v_{d}(i)$",'Interpreter','Latex')
set(gca,'FontSize',16,'fontname','Times New Roman')
xlim([0,11])
ylim([-2,2])
grid on

subplot(1,4,3)
plot(kappa_r,'-vk','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(2)}-kappa_est_sta_bar_all{1,n_sam_choose(2)},'--or','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(2)}-kappa_est_sta_bar_all{2,n_sam_choose(2)},'-.sb','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(2)},'-r','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(2)},'-b','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{1,n_sam_choose(2)}+kappa_est_sta_bar_all{1,n_sam_choose(2)},'--or','LineWidth',2)
hold on
plot(kappa_est_sta_median_all{2,n_sam_choose(2)}+kappa_est_sta_bar_all{2,n_sam_choose(2)},'-.sb','LineWidth',2)
hold off
title('(c) Confidence bound $N=15$','Interpreter','Latex')
legend('Real','SOTA (Boud)','Proposed (Bound)','SOTA (Median)','Proposed (Median)','Interpreter','Latex')
xlabel('Node index $i$','Interpreter','Latex')
ylabel("$w_{d}(i)v_{d}(i)$",'Interpreter','Latex')
set(gca,'FontSize',16,'fontname','Times New Roman')
xlim([0,11])
ylim([-2,2])
grid on

subplot(1,4,4)
% Statistical analysis of node estimation accuracy. Results of 2,000 trials are reported.
plot(n_sam_all,cor_prob(1,:)*100,'--or','LineWidth',2)
hold on
plot(n_sam_all,cor_prob(2,:)*100,'--sb','LineWidth',2)
hold off
title('(d) Reg. node estimation','Interpreter','Latex')
legend('SOTA','Proposed','Interpreter','Latex')
xlabel('$N$','Interpreter','Latex')
ylabel("Accuracy [$\%$]",'Interpreter','Latex')
set(gca,'FontSize',16,'fontname','Times New Roman')
xlim([0,16])
ylim([0,100])
grid on

