# A Slingshot Approach to Learning in Monotone Games

## Run Experiments
In order to investigate the performance of FTRL-SP in Three-Player Biased Rock-Paper-Scissors with full feedback, execute the following command:
```bash
# D_{psi}=KL G=KL
$ python main.py n_trials=10 T=100000 game_name=three_biased_rps algorithm.FTRLSP.full.learning_rate=0.1 algorithm.FTRLSP.full.mutation_rate=0.1 alg_name=FTRLSP algorithm.FTRLSP.full.random_init=True algorithm.FTRLSP.full.regularizer=entropy algorithm.FTRLSP.full.mutation_divergence=kl feedback=full algorithm.FTRLSP.full.update_slingshot_freq=100
# D_{psi}=KL G=Reverse KL
$ python main.py n_trials=10 T=100000 game_name=three_biased_rps algorithm.FTRLSP.full.learning_rate=0.1 algorithm.FTRLSP.full.mutation_rate=0.1 alg_name=FTRLSP algorithm.FTRLSP.full.random_init=True algorithm.FTRLSP.full.regularizer=entropy algorithm.FTRLSP.full.mutation_divergence=reverse_kl feedback=full algorithm.FTRLSP.full.update_slingshot_freq=100
# D_{psi}=Squared L2 G=Squared L2
$ python main.py n_trials=10 T=100000 game_name=three_biased_rps algorithm.FTRLSP.full.learning_rate=0.1 algorithm.FTRLSP.full.mutation_rate=1.0 alg_name=FTRLSP algorithm.FTRLSP.full.random_init=True algorithm.FTRLSP.full.regularizer=l2 algorithm.FTRLSP.full.mutation_divergence=l2 feedback=full algorithm.FTRLSP.full.update_slingshot_freq=20
```

To evaluate FTRL-SP via an experiment in Three-Player Biased Rock-Paper-Scissors with noisy feedback, execute the following command:
```bash
# D_{psi}=KL G=KL
$ python main.py n_trials=5 T=100000 game_name=three_biased_rps algorithm.FTRLSP.noisy.learning_rate=0.01 algorithm.FTRLSP.noisy.mutation_rate=0.1 alg_name=FTRLSP algorithm.FTRLSP.noisy.random_init=True algorithm.FTRLSP.noisy.regularizer=entropy algorithm.FTRLSP.noisy.mutation_divergence=kl feedback=noisy algorithm.FTRLSP.noisy.update_slingshot_freq=1000
# D_{psi}=KL G=Reverse KL
$ python main.py n_trials=10 T=100000 game_name=three_biased_rps algorithm.FTRLSP.noisy.learning_rate=0.01 algorithm.FTRLSP.noisy.mutation_rate=0.1 alg_name=FTRLSP algorithm.FTRLSP.noisy.random_init=True algorithm.FTRLSP.noisy.regularizer=entropy algorithm.FTRLSP.noisy.mutation_divergence=reverse_kl feedback=noisy algorithm.FTRLSP.noisy.update_slingshot_freq=1000
# D_{psi}=Squared L2 G=Squared L2
$ python main.py n_trials=10 T=100000 game_name=three_biased_rps algorithm.FTRLSP.noisy.learning_rate=0.01 algorithm.FTRLSP.noisy.mutation_rate=1.0 alg_name=FTRLSP algorithm.FTRLSP.noisy.random_init=True algorithm.FTRLSP.noisy.regularizer=l2 algorithm.FTRLSP.noisy.mutation_divergence=l2 feedback=noisy algorithm.FTRLSP.noisy.update_slingshot_freq=200
```