INITIAL_PASSAGES_QUESTION_PROMPT_TEMPLATE = """
{passages}

{question}
""".strip()

INITIAL_QUESTION_PROMPT_TEMPLATE = """
{question}
""".strip()


CHECKLIST_EVALUATION_TEMPLATE = """
You will be provided with a model's answer to the given query and an evaluation checklist that contains multiple questions.

Your task is to evaluate the quality of the model's answer based on the given evaluation checklist that contains multiple questions, by answering “Yes” or “No” to each question. 

### Query:
{query}

### Model's Answer:
{model_answer}

### Checklist (Evaluation Items):
{checklist}

### Output Format:
- Provide the final answer in the format of "<Q>: <Yes or No>".
- Do not provide any decision except "Yes" or "No".
- Do not include any additional explanations or descriptions.

Answer: 
""".strip()


NEXT_TURN_EVALUATION_TEMPLATE_V1 = """
Please refine your previous response by considering the following key points:
{key_points}
""".strip()

NEXT_TURN_EVALUATION_TEMPLATE = """
Please refine your previous response by considering the following feedbacks:
{feedbacks}
""".strip()

NEXT_TURN_EVALUATION_DEFAULT_TEMPLATE_W_CHECKLIST = """
You are provided with evaluation criteria to determine if a given answer satisfies the requirements of the question.

### Evaluation Criteria:
- {checklist}

Considering the provided criteria, if you think there is absolutely nothing left to refine, respond with "[TERMINATE]". Otherwise, if there is still room for improvement, continue refining your previous response.

Do not format your response as answers to individual questions within the evaluation criteria.
""".strip()


NEXT_TURN_EVALUATION_SELF_REFLECTION_TEMPLATE = """
I'm not perfectly satisfied with this response but I'm willing to take your response if you think there is absolutely nothing to be refined.
""".strip()

NEXT_TURN_EVALUATION_DEFAULT_TEMPLATE = """
If you think there is absolutely nothing left to refine, respond with "[TERMINATE]". Otherwise, if there is still room for improvement, continue refining your previous response.
""".strip()

NEXT_TURN_PARTIAL_FEEDBACK_EVALUATION_TEMPLATE = """
Please refine your previous response by considering the following feedbacks:
{feedbacks}
""".strip()