#!/bin/bash

export CUDA_VISIBLE_DEVICES='1'
export HYDRA_FULL_ERROR=1

MODEL_INFOS=(
    "openrouter/google/gemini-2.5-flash-preview gemini_2_5_flash_preview"
)

EVALUATOR_MODEL_INFOS=(
    "openrouter/openai/gpt-4.1 gpt_4_1"
)

seeds=(0) # 1 2)

DATA_PATH="$1"
FIELD="$2"
TEMPERATURE=0.9
TOP_P=1.0
MAX_TOKENS=8192
MAX_TURN_NUM=5
CHECKLIST_TYPE="default"
CONFIG_PATH="configs"
CONFIG_NAME="config"

COMMON_ARGS=(
  "--config-path" "$CONFIG_PATH"
  "--config-name" "$CONFIG_NAME"
  "dataset.data_path=$DATA_PATH"
  "agent.temperature=$TEMPERATURE"
  "agent.top_p=$TOP_P"
  "agent.max_tokens=$MAX_TOKENS"
  "experimental_setup.max_turn_num=$MAX_TURN_NUM"
  "experimental_setup.checklist_type=$CHECKLIST_TYPE"
  #"experimental_setup.debug=True"
)

for evaluator_info in "${EVALUATOR_MODEL_INFOS[@]}"; do
    evaluator_path=$(echo "$evaluator_info" | awk '{print $1}')
    evaluator_name=$(echo "$evaluator_info" | awk '{print $2}')

    echo "########################################"
    echo "Evaluator: ${evaluator_name} (${evaluator_path})"
    echo "########################################"

    for model_info in "${MODEL_INFOS[@]}"; do
        model_path=$(echo "$model_info" | awk '{print $1}')
        model_name=$(echo "$model_info" | awk '{print $2}')

        echo "========================================"
        echo "Main Model: ${model_name} (${model_path})"
        echo "========================================"

        for seed in "${seeds[@]}"; do
            echo "----------------------------------------"
            echo "Running seed=${seed} ..."
            echo "----------------------------------------"

            for turn_num in $(seq 2 $MAX_TURN_NUM); do
                echo "  [Turn=${turn_num}]"
                filename=$(basename "$DATA_PATH" .json)
                output_dir="results/${filename}/${CHECKLIST_TYPE}/${seed}/${TEMPERATURE}_${TOP_P}/${evaluator_name}/${model_name}"
                output_path="${output_dir}/${turn_num}/evaluation_results.json"
                
                # Skip if result already exists
                if [ -e "$output_path" ]; then
                    echo "    Output exists at $output_path, skipping."
                    continue
                fi

                python main_for_expr.py \
                  "${COMMON_ARGS[@]}" \
                  "agent.model_name=$model_name" \
                  "agent.model_path=$model_path" \
                  "evaluator.model_name=$evaluator_name" \
                  "evaluator.model_path=$evaluator_path" \
                  "experimental_setup.seed=$seed" \
                  "experimental_setup.target_turn_num=$turn_num" \
                  "experimental_setup.field=$FIELD"
            done

            echo "----------------------------------------"
            echo "Finished all turns for seed=${seed}"
            echo "----------------------------------------"
        done
    done
done
