# Stochastic Gaussian Embedding Vision Transformer 
This work builds upon the data2vec BEIT pipeline, with 
```

Example command to pre-train a stochatsic vision transformer from scratch
```

OMP_NUM_THREADS=1 timeout 23h python -m torch.distributed.launch --nproc_per_node=8 run_cyclical.py \
      --model dist_beit_base_patch16_224 --num_mask_patches 120 --data_path $PATH \
      --output_dir $OUTPUT --log_dir $LOG --batch_size 32 --seed 0 --target_layers [6,7,8,9,10,11] \
      --ema_decay 0.9998 --ema_start_at 0 --ema_decay_init 0.999 --lr 1e-3 --warmup_epochs 50 --epochs 300 --clip_grad \
      3.0 --layer_scale_init_value 1e-4 --drop_path 0.25 --drop 0.3 --layer_results "end" \
      --weight_decay 0.05 --max_mask_patches_per_block 196 --min_mask_patches_per_block 16 --data_set "CIFAR100"\
      --l1_beta=2.0 --world_size 8 --num_workers 10 --dist_url "env://" --stochastic \
```

Example command to fine-tune a stochastic vision transformer
```

OMP_NUM_THREADS=1 python -m torch.distributed.launch --nproc_per_node=8 run_class_finetuning.py \
      --model dist_beit_base_patch16_224 --finetune $CHECKPOINT --data_path  $PATH \
      --output_dir $OUTPUT --log_dir "log" --batch_size 64 --lr 1e-3 --update_freq \
      1 --warmup_epochs 0 --epochs 50 --layer_decay 0.65 --drop_path 0.0 --drop 0 \
      --weight_decay 0.0 --mixup 0 --cutmix 0 --enable_deepspeed --nb_classes \
      100 --target_layer -1 --world_size 8 --dist_url "env://" --data_set \
      "CIFAR100" --stochastic 

```

## CITATION

```
@misc{https://doi.org/10.48550/arxiv.2202.03555,
  doi = {10.48550/ARXIV.2202.03555},
  url = {https://arxiv.org/abs/2202.03555},
  author = {Baevski, Alexei and Hsu, Wei-Ning and Xu, Qiantong and Babu, Arun and Gu, Jiatao and Auli, Michael},
  keywords = {Machine Learning (cs.LG), FOS: Computer and information sciences, FOS: Computer and information sciences},
  title = {data2vec: A General Framework for Self-supervised Learning in Speech, Vision and Language},
  publisher = {arXiv},
  year = {2022},
  copyright = {arXiv.org perpetual, non-exclusive license}
}
```
