#!/bin/bash


# Define the array of learning rates

SEEDS=(1000)
LRS=(0.002)
wd=0.0
optimiser="adamw"
dataset="flowers"


# Loop over each learning rate
for lr in "${LRS[@]}"; do
    for seed in "${SEEDS[@]}"; do        
            python ./example/parameter_shift.py --lr $lr --seed $seed --opt $optimiser --weight_decay $wd --dataset $dataset
            # Wait for a short time to avoid overwhelming the scheduler
            sleep 2
  
    done
done

echo "All jobs submitted."