set -x
ENGINE=${1:-vllm}

TRAIN_METHOD="CPPO" 
TRAIN_BATCH_SIZE=512
PPO_MINI_BATCH_SIZE=64
PPO_MICRO_BATCH_SIZE_PER_GPU=8
TEST_FREQ=10
EPOCHS=2
export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
N_GPUS=8

## TODO:
PROJECT_NAME="Qwen2.5-VL-3B-Instruct-virl39k-CPPO"  # TODO: change if needed

EXP_NAME="exp1_$TRAIN_METHOD" # TODO: change if needed

TRAIN_DATA="datasets/ViRL39K/data_forVerl/train.parquet" # TODO: change if needed

SAVE_DIR="checkpoints/$PROJECT_NAME/$EXP_NAME" # TODO: change if needed

MODEL_PATH="pretrained_models/Qwen2.5-VL-3B-Instruct" # TODO: change if needed

VAL_DATA="datasets/geometry3k/data_forVerl/test.parquet" # TODO : change if needed

filter_overlong_prompts=True
val_before_train=False
REWARD_MANAGER="naive"

USE_VISION_CSL_LOSS=True

python3 -m recipe.vision_grpo.main_ppo \
    algorithm.adv_estimator=grpo \
    algorithm.use_kl_in_reward=False \
    data.train_files=${TRAIN_DATA} \
    data.val_files=${VAL_DATA} \
    data.train_batch_size=${TRAIN_BATCH_SIZE} \
    data.max_prompt_length=512 \
    data.max_response_length=4096 \
    data.filter_overlong_prompts=${filter_overlong_prompts} \
    data.truncation='right' \
    data.image_key=images \
    data.custom_cls.path="verl/utils/dataset/vision_rl_dataset.py" \
    data.custom_cls.name=RLHFDataset_counterFactual \
    actor_rollout_ref.model.path=${MODEL_PATH} \
    actor_rollout_ref.actor.optim.lr=1e-6 \
    actor_rollout_ref.model.use_remove_padding=True \
    actor_rollout_ref.actor.ppo_mini_batch_size=${PPO_MINI_BATCH_SIZE} \
    actor_rollout_ref.actor.ppo_micro_batch_size_per_gpu=${PPO_MICRO_BATCH_SIZE_PER_GPU} \
    actor_rollout_ref.actor.use_kl_loss=True \
    actor_rollout_ref.actor.use_vision_csl_loss=${USE_VISION_CSL_LOSS} \
    actor_rollout_ref.actor.kl_loss_coef=0.01 \
    actor_rollout_ref.actor.kl_loss_type=low_var_kl \
    actor_rollout_ref.actor.entropy_coeff=0 \
    actor_rollout_ref.model.enable_gradient_checkpointing=True \
    actor_rollout_ref.actor.fsdp_config.param_offload=False \
    actor_rollout_ref.actor.fsdp_config.optimizer_offload=False \
    actor_rollout_ref.rollout.log_prob_micro_batch_size_per_gpu=20 \
    actor_rollout_ref.rollout.tensor_model_parallel_size=2 \
    actor_rollout_ref.rollout.name=$ENGINE \
    actor_rollout_ref.rollout.engine_kwargs.vllm.disable_mm_preprocessor_cache=True \
    actor_rollout_ref.rollout.gpu_memory_utilization=0.5 \
    actor_rollout_ref.rollout.enable_chunked_prefill=False \
    actor_rollout_ref.rollout.enforce_eager=False \
    actor_rollout_ref.rollout.free_cache_engine=True \
    actor_rollout_ref.rollout.n=5 \
    actor_rollout_ref.ref.log_prob_micro_batch_size_per_gpu=20 \
    actor_rollout_ref.ref.fsdp_config.param_offload=True \
    reward_model.reward_manager=${REWARD_MANAGER} \
    trainer.critic_warmup=0 \
    trainer.logger='["console","tensorboard"]' \
    trainer.project_name=${PROJECT_NAME} \
    trainer.experiment_name=${EXP_NAME} \
    trainer.n_gpus_per_node=${N_GPUS} \
    trainer.nnodes=1 \
    trainer.save_freq=10 \
    trainer.test_freq=${TEST_FREQ} \
    trainer.val_before_train=${val_before_train} \
    trainer.default_local_dir=${SAVE_DIR} \
    trainer.rollout_data_dir=outputs/${PROJECT_NAME}/${EXP_NAME}/rollout_dump_train \
    trainer.validation_data_dir=outputs/${PROJECT_NAME}/${EXP_NAME}/rollout_dump_val \
    trainer.total_epochs=${EPOCHS} $@
