/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.engine;

import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.rest.Files;
import edu.wisc.game.util.Logging;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class AllRuleSets
extends HashMap<String, RuleSet> {
    private static AllRuleSets allRuleSets = new AllRuleSets();

    public static RuleSet read(File f) throws IOException, RuleParseException {
        if (f == null) {
            String[] permitAll = new String[]{"()"};
            return new RuleSet(permitAll);
        }
        if (!f.canRead()) {
            throw new IOException("Cannot read rule file: " + f);
        }
        Logging.info("Reading rule set file " + f);
        String text = Util.readTextFile(f);
        return new RuleSet(text);
    }

    RuleSet get(String ruleSetName) throws IOException, RuleParseException {
        RuleSet rules = (RuleSet)super.get(ruleSetName);
        if (rules == null) {
            File f = Files.rulesFile(ruleSetName);
            rules = AllRuleSets.read(f);
            Logging.info("AllRuleSets: Loaded rule set named " + ruleSetName);
            if (Files.rulesCanBeCached(ruleSetName)) {
                super.put(ruleSetName, rules);
            }
        }
        return rules;
    }

    public static RuleSet obtain(String ruleSetName) throws IOException, RuleParseException {
        if (ruleSetName == null || ruleSetName.trim().equals("")) {
            throw new IOException("No rules set name specified");
        }
        return allRuleSets.get(ruleSetName);
    }

    public static void clearAll() {
        allRuleSets.clear();
        Logging.info("AllRuleSets: Cleared the rule table");
    }
}

