/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.engine;

import edu.wisc.game.engine.AllRuleSets;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.rest.Files;
import edu.wisc.game.rest.ParaSet;
import edu.wisc.game.rest.TrialList;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.GameGenerator;
import edu.wisc.game.sql.RandomGameGenerator;
import edu.wisc.game.sql.TrivialGameGenerator;
import edu.wisc.game.util.IllegalInputException;
import edu.wisc.game.util.ParseConfig;
import edu.wisc.game.util.RandomRG;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class Captive {
    static String asComment(String s) {
        CharSequence[] v = s.split("\n");
        for (int i = 0; i < v.length; ++i) {
            v[i] = "#" + (String)v[i];
        }
        return String.join((CharSequence)"\n", v);
    }

    private static void usage() {
        Captive.usage(null);
    }

    private static void usage(String msg) {
        System.err.println("Usage:\n");
        System.err.println("  java [options]  edu.wisc.game.engine.Captive game-rule-file.txt board-file.json");
        System.err.println("  java [options]  edu.wisc.game.engine.Captive game-rule-file.txt npieces [nshapes ncolors]");
        System.err.println("Each of 'npieces', 'nshapes', and 'ncolors' is either 'n' (for a single value) or 'n1:n2' (for a range). '0' means 'any'");
        if (msg != null) {
            System.err.println(msg + "\n");
        }
        System.exit(1);
    }

    static GameGenerator buildGameGenerator(ParseConfig ht, String[] argv) throws IOException, RuleParseException, ReflectiveOperationException, IllegalInputException {
        String fname;
        File f;
        long seed = ht.getOptionLong("seed", 0L);
        RandomRG random = seed != 0L ? new RandomRG(seed) : new RandomRG();
        int ja = 0;
        if (argv.length < 2) {
            throw new IllegalInputException("No params specified");
        }
        if (!(f = new File(fname = argv[ja++])).canRead()) {
            throw new IllegalInputException("Cannot read file " + f);
        }
        String b = argv[ja++];
        if (f.getName().endsWith(".csv")) {
            TrialList trialList = new TrialList(f);
            int rowNo = Integer.parseInt(b);
            if (rowNo <= 0 || rowNo > trialList.size()) {
                throw new IllegalInputException("Invalid row number (" + rowNo + "). Row numbers should be positive, and should not exceed the size of the trial list (" + trialList.size() + ")");
            }
            ParaSet para = (ParaSet)trialList.elementAt(rowNo - 1);
            return GameGenerator.mkGameGenerator(random, para);
        }
        if (b.indexOf(".") >= 0) {
            File bf = new File(b);
            Board board = Board.readBoard(bf);
            return new TrivialGameGenerator(random, new Game(AllRuleSets.read(f), board));
        }
        return RandomGameGenerator.buildFromArgv(random, f, ht, argv, ja - 1);
    }

    public static void main(String[] argv) throws IOException, RuleParseException, ReflectiveOperationException, IllegalInputException {
        Game game;
        Episode epi;
        ParseConfig ht = new ParseConfig();
        argv = ht.enrichFromArgv(argv);
        Episode.OutputMode outputMode = ht.getOptionEnum(Episode.OutputMode.class, "output", Episode.OutputMode.FULL);
        String inputDir = ht.getOption("inputDir", null);
        if (inputDir != null) {
            Files.setInputDir(inputDir);
        }
        GameGenerator gg = null;
        try {
            gg = Captive.buildGameGenerator(ht, argv);
        }
        catch (Exception ex) {
            Captive.usage("Cannot create game generator. Problem: " + ex.getMessage());
        }
        int gameCnt = 0;
        do {
            ++gameCnt;
            game = gg.nextGame();
            if (outputMode != Episode.OutputMode.FULL) continue;
            System.out.println(Captive.asComment(game.rules.toString()));
        } while ((epi = new Episode(game, outputMode, new InputStreamReader(System.in), new PrintWriter(System.out, true))).playGame(gameCnt));
    }
}

