/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.engine;

import edu.wisc.game.engine.RuleSet;
import edu.wisc.game.parser.RuleParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class ConvertRules {
    public static void main(String[] argv) throws IOException, RuleParseException {
        JsonObject r;
        String fname = argv[0];
        String outdirName = argv[1];
        File outdir = new File(outdirName);
        if (!outdir.isDirectory()) {
            ConvertRules.usage("Not a directory: " + outdir);
        }
        JsonReader jsonReader = Json.createReader((Reader)new FileReader(fname));
        JsonObject obj = jsonReader.readObject();
        jsonReader.close();
        JsonObject games = obj.getJsonObject("games");
        JsonObject ruleArrays = obj.getJsonObject("ruleArrays");
        HashMap<String, String> ruleArrayToGame = new HashMap<String, String>();
        for (JsonValue val : games.values()) {
            r = (JsonObject)val;
            ruleArrayToGame.put(r.getString("ruleArray"), r.getString("name"));
        }
        for (String key : ruleArrays.keySet()) {
            r = ruleArrays.getJsonObject(key);
            String stringified = r.getString("stringified");
            String origName = r.getString("name");
            String gameName = (String)ruleArrayToGame.get(key);
            String name = gameName != null ? gameName : origName;
            JsonArray oa = null;
            if (r.containsKey((Object)"order")) {
                oa = r.getJsonArray("order");
            }
            File g = new File(outdir, name + ".txt");
            PrintWriter w = new PrintWriter(new FileWriter(g));
            w.println("# ruleArrayName=" + origName);
            if (gameName != null) {
                w.println("# used in game=" + gameName);
            }
            if (stringified.startsWith("\"") && stringified.endsWith("\"")) {
                stringified = stringified.replaceFirst("\"", "").replaceFirst("\"$", "");
            }
            try {
                RuleSet z;
                if (oa != null) {
                    w.println("Order Custom=" + oa.toString().trim());
                    z = new RuleSet(stringified);
                    z.forceOrder("Custom");
                    w.println(z.toSrc());
                } else {
                    z = new RuleSet(stringified);
                    w.println(z.toSrc());
                }
            }
            catch (RuleParseException ex) {
                System.err.println("Parse exception when working with exp=" + stringified);
                throw ex;
            }
            w.close();
        }
    }

    private static void usage() {
        ConvertRules.usage(null);
    }

    private static void usage(String msg) {
        System.err.println("Usage:\n");
        System.err.println("  java [options]  edu.wisc.game.engine.ConverRules input.json outdir");
        if (msg != null) {
            System.err.println(msg + "\n");
        }
        System.exit(1);
    }
}

