/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.engine;

import edu.wisc.game.engine.Captive;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.Game;
import edu.wisc.game.sql.GameGenerator;
import edu.wisc.game.util.ParseConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GameSocketServerThread
extends Thread {
    private final Socket socket;

    public GameSocketServerThread(Socket _socket) {
        super("GameSocketServerThread " + _socket.getInetAddress());
        this.socket = _socket;
    }

    private static void respond(PrintWriter out, int code, String msg) {
        String s = "" + code;
        int finishCode = 0;
        int attemptCnt = 0;
        s = s + " " + finishCode + " " + attemptCnt;
        if (msg != null) {
            s = s + "\n" + msg;
        }
        out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long id = this.getId();
        InetAddress ia = this.socket.getInetAddress();
        System.out.println("Thread " + id + ": connection from " + ia);
        int gameCnt = 0;
        try {
            Game game;
            Episode epi;
            Episode.OutputMode outputMode;
            GameGenerator gg;
            BufferedReader in;
            PrintWriter out;
            block59: {
                out = new PrintWriter(this.socket.getOutputStream(), true);
                in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                LineNumberReader r = new LineNumberReader(in);
                String line = null;
                do {
                    if ((line = r.readLine()) == null) return;
                } while ((line = line.trim()).equals(""));
                Pattern pat = Pattern.compile("^(\\S+)\\s*");
                Matcher m = pat.matcher(line);
                if (!m.find()) {
                    GameSocketServerThread.respond(out, -1, "# Invalid input - cannot find the command in this line: " + line);
                    return;
                }
                String cmd = m.group(1);
                String tail = line.substring(m.end());
                if (cmd.equals("EXIT")) {
                    return;
                }
                if (cmd.equals("GAME")) {
                    if (tail.length() == 0) {
                        GameSocketServerThread.respond(out, -5, "No rule file or trial list file specified");
                        return;
                    }
                    String[] argv = tail.split("\\s+");
                    GameSocketServerThread.stripQuotes(argv);
                    ParseConfig ht = new ParseConfig();
                    argv = ht.enrichFromArgv(argv);
                    try {
                        gg = Captive.buildGameGenerator(ht, argv);
                    }
                    catch (Exception ex) {
                        GameSocketServerThread.respond(out, -5, "Exception: " + ex.getMessage());
                        in.close();
                        out.close();
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        System.out.println("Thread " + id + ": finishing after playing " + gameCnt + " episodes");
                        return;
                    }
                    outputMode = Episode.OutputMode.STANDARD;
                    break block59;
                } else {
                    GameSocketServerThread.respond(out, -1, "Invalid command " + cmd);
                    return;
                }
                finally {
                    in.close();
                }
                finally {
                    out.close();
                }
            }
            while ((epi = new Episode(game = gg.nextGame(), outputMode, in, out)).playGame(++gameCnt)) {
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
            System.out.println("Thread " + id + ": finishing after playing " + gameCnt + " episodes");
        }
    }

    static void stripQuotes(String[] argv) {
        for (int j = 0; j < argv.length; ++j) {
            String a = argv[j];
            if (a.length() < 2 || (!a.startsWith("\"") || !a.endsWith("\"")) && (!a.startsWith("'") || !a.endsWith("'"))) continue;
            argv[j] = a.substring(1, a.length() - 1);
        }
    }
}

