/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.engine;

import edu.wisc.game.parser.Expression;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.sql.Board;
import edu.wisc.game.util.Util;
import java.lang.invoke.CallSite;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class Order
extends Vector<Vector<Integer>> {
    static HashMap<String, Order> predefinedOrders = new HashMap();

    private Order() {
    }

    @Override
    public String toString() {
        Vector<CallSite> q = new Vector<CallSite>();
        for (Vector v : this) {
            if (v.size() == 1) {
                q.add((CallSite)((Object)("" + v.get(0))));
                continue;
            }
            q.add((CallSite)((Object)("[" + Util.joinNonBlank(",", v) + "]")));
        }
        return "[" + String.join((CharSequence)",", q) + "]";
    }

    Order reverse() {
        Order q = new Order();
        for (int j = this.size() - 1; j >= 0; --j) {
            q.add((Vector)this.get(j));
        }
        return q;
    }

    private static int distToCorner(int pos) {
        Board.Pos p = new Board.Pos(pos).flip2corner();
        return p.norm2sq(new Board.Pos(0, 0));
    }

    private void validate() throws RuleParseException {
        HashSet<Integer> h = new HashSet<Integer>();
        int M = 36;
        for (Vector v : this) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                if (pos < 1 || pos > 36) {
                    throw new RuleParseException("Invalid order: illegal value " + pos);
                }
                if (h.contains(pos)) {
                    throw new RuleParseException("Invalid order: duplicate value " + pos);
                }
                h.add(pos);
            }
        }
    }

    Order(Expression.BracketList bex) throws RuleParseException {
        for (Expression a : bex) {
            Vector<Integer> v = new Vector<Integer>();
            if (a instanceof Expression.Num) {
                v.add(((Expression.Num)a).nVal);
            } else if (a instanceof Expression.BracketList) {
                for (Expression b : (Expression.BracketList)a) {
                    if (b instanceof Expression.Num) {
                        v.add(((Expression.Num)b).nVal);
                        continue;
                    }
                    throw new RuleParseException("Cannot parse as an order: " + bex);
                }
            }
            this.add(v);
        }
        this.validate();
    }

    Order(PositionSelector mode) {
        if (mode == PositionSelector.B) {
            for (int y = 1; y <= 6; ++y) {
                Vector<Integer> v = new Vector<Integer>();
                for (int x = 1; x <= 6; ++x) {
                    v.add(Board.xynum(x, y));
                }
                this.add(v);
            }
        } else if (mode == PositionSelector.L) {
            for (int x = 1; x <= 6; ++x) {
                Vector<Integer> v = new Vector<Integer>();
                for (int y = 1; y <= 6; ++y) {
                    v.add(Board.xynum(x, y));
                }
                this.add(v);
            }
        } else if (mode == PositionSelector.L1) {
            for (int y = 6; y >= 1; --y) {
                for (int x = 1; x <= 6; ++x) {
                    Vector<Integer> v = new Vector<Integer>();
                    v.add(Board.xynum(x, y));
                    this.add(v);
                }
            }
        } else if (mode == PositionSelector.L2) {
            for (int y = 6; y >= 1; --y) {
                for (int x = 6; x >= 1; --x) {
                    Vector<Integer> v = new Vector<Integer>();
                    v.add(Board.xynum(x, y));
                    this.add(v);
                }
            }
        } else if (mode == PositionSelector.L3) {
            for (int x = 6; x >= 1; --x) {
                for (int y = 6; y >= 1; --y) {
                    Vector<Integer> v = new Vector<Integer>();
                    v.add(Board.xynum(x, y));
                    this.add(v);
                }
            }
        } else if (mode == PositionSelector.L4) {
            for (int x = 1; x <= 6; ++x) {
                for (int y = 6; y >= 1; --y) {
                    Vector<Integer> v = new Vector<Integer>();
                    v.add(Board.xynum(x, y));
                    this.add(v);
                }
            }
        } else if (mode == PositionSelector.NearestObject) {
            Vector<Integer> w = new Vector<Integer>();
            for (int k = 1; k <= 36; ++k) {
                w.add(new Integer(k));
            }
            w.sort(new DistanceComparator());
            Vector<Integer> v = null;
            for (Integer q : w) {
                if (v == null) {
                    v = new Vector<Integer>();
                } else if (Order.distToCorner(q) != Order.distToCorner((Integer)v.get(0))) {
                    this.add(v);
                    v = new Vector();
                }
                v.add(q);
            }
            this.add(v);
        }
    }

    private static void put(PositionSelector key, Order val) {
        predefinedOrders.put(key.toString(), val);
    }

    private static Order get(PositionSelector key) {
        return predefinedOrders.get(key.toString());
    }

    private static void init() {
        for (PositionSelector key : PositionSelector.keys) {
            Order.put(key, new Order(key));
        }
        Order.put(PositionSelector.T, Order.get(PositionSelector.B).reverse());
        Order.put(PositionSelector.R, Order.get(PositionSelector.L).reverse());
        Order.put(PositionSelector.Farthest, Order.get(PositionSelector.NearestObject).reverse());
    }

    public BitSet findEligiblePieces(BitSet onBoard) {
        BitSet result = new BitSet();
        for (Vector v : this) {
            BitSet q = Util.toBitSet(v);
            q.and(onBoard);
            result.or(q);
            if (result.isEmpty()) continue;
            return result;
        }
        return onBoard;
    }

    static {
        Order.init();
    }

    private static class DistanceComparator
    implements Comparator<Integer> {
        private DistanceComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return Order.distToCorner(o1) - Order.distToCorner(o2);
        }
    }

    public static enum PositionSelector {
        L1,
        L2,
        L3,
        L4,
        T,
        B,
        R,
        L,
        NearestObject,
        Farthest;

        static PositionSelector[] keys;

        static {
            keys = new PositionSelector[]{L1, L2, L3, L4, B, L, NearestObject};
        }
    }
}

