/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.engine;

import edu.wisc.game.engine.Order;
import edu.wisc.game.parser.Expression;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.parser.Token;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.ImageObject;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class RuleSet {
    public Vector<String> description = new Vector();
    public TreeMap<String, Order> orders = new TreeMap();
    public Vector<Row> rows = new Vector();

    public RuleSet(String ruleText) throws RuleParseException {
        this(ruleText.split("\n"));
    }

    public RuleSet(String[] rr) throws RuleParseException {
        boolean topCommentEnded = false;
        for (String r : rr) {
            Row row;
            if ((r = r.trim()).startsWith("#") || r.length() == 0) {
                String s;
                if (topCommentEnded || (s = r.replaceAll("^#+-* *", "")).length() <= 0) continue;
                this.description.add(s);
                continue;
            }
            topCommentEnded = true;
            Vector<Token> tokens = Token.tokenize(r);
            if (tokens.isEmpty()) {
                throw new RuleParseException("No data found in the line: " + r);
            }
            Token a = tokens.get(0);
            if (this.rows.size() == 0 && a.type == Token.Type.ID && a.sVal.equalsIgnoreCase("Order")) {
                tokens.remove(0);
                if (tokens.isEmpty() || tokens.get((int)0).type != Token.Type.ID) {
                    throw new RuleParseException("Missing order name in an order line: " + r);
                }
                String name = tokens.remove((int)0).sVal;
                if (tokens.isEmpty() || tokens.get((int)0).type != Token.Type.EQUAL) {
                    throw new RuleParseException("Missing equal sign in an order line: " + r);
                }
                tokens.remove(0);
                Expression.BracketList ex = Expression.mkBracketList(tokens);
                if (!tokens.isEmpty()) {
                    throw new RuleParseException("Invalid order description: " + r);
                }
                this.orders.put(name, new Order(ex));
                continue;
            }
            try {
                row = new Row(tokens, this.orders);
            }
            catch (RuleParseException ex) {
                throw new RuleParseException("Failed to parse rule row: " + r, ex);
            }
            if (row.size() == 0) {
                throw new RuleParseException("No rules found in this line: " + r);
            }
            this.rows.add(row);
        }
        if (this.rows.size() == 0) {
            throw new RuleParseException("The rule set contains no rules");
        }
    }

    public String toString() {
        Vector<CallSite> v = new Vector<CallSite>();
        for (String name : this.orders.keySet()) {
            v.add((CallSite)((Object)("Order " + name + "=" + this.orders.get(name))));
        }
        Object s = String.join((CharSequence)"\n", v);
        if (v.size() > 0) {
            s = (String)s + "\n";
        }
        return (String)s + Util.joinNonBlank("\n", this.rows);
    }

    public String toSrc() {
        ReportedSrc rr = new ReportedSrc();
        Vector<String> v = new Vector<String>();
        v.addAll(rr.orders);
        v.addAll(rr.rows);
        return String.join((CharSequence)"\n", v);
    }

    public ReportedSrc reportSrc() {
        return new ReportedSrc();
    }

    void forceOrder(String orderName) {
        for (Row row : this.rows) {
            row.forceOrder(orderName);
        }
    }

    public HashSet<Piece.Shape> listAllShapes() {
        HashSet<Piece.Shape> h = new HashSet<Piece.Shape>();
        for (Row row : this.rows) {
            h.addAll(row.listAllShapes());
        }
        return h;
    }

    public HashSet<Piece.Color> listAllColors() {
        HashSet<Piece.Color> h = new HashSet<Piece.Color>();
        for (Row row : this.rows) {
            h.addAll(row.listAllColors());
        }
        return h;
    }

    public TreeMap<String, TreeSet<String>> listAllPropValues() {
        TreeMap<String, TreeSet<String>> propValues = new TreeMap<String, TreeSet<String>>();
        for (Row row : this.rows) {
            TreeMap<String, TreeSet<String>> w = row.listAllPropValues();
            for (String p : w.keySet()) {
                TreeSet<String> h = propValues.get(p);
                if (h == null) {
                    h = new TreeSet();
                    propValues.put(p, h);
                }
                h.addAll((Collection<String>)w.get(p));
            }
        }
        return propValues;
    }

    public static void main(String[] argv) throws IOException, RuleParseException {
        System.out.println("Have " + argv.length + " files to read");
        for (String a : argv) {
            File f = new File(a);
            System.out.println("Reading file " + f);
            String text = Util.readTextFile(f);
            RuleSet rules = new RuleSet(text);
            System.out.println(rules);
        }
    }

    public class ReportedSrc {
        Vector<String> orders = new Vector();
        Vector<String> rows = new Vector();

        public Vector<String> getOrders() {
            return this.orders;
        }

        public Vector<String> getRows() {
            return this.rows;
        }

        ReportedSrc() {
            for (Map.Entry<String, Order> e : RuleSet.this.orders.entrySet()) {
                this.orders.add("Order " + e.getKey() + "=" + e.getValue());
            }
            for (Row row : RuleSet.this.rows) {
                this.rows.add(row.toSrc());
            }
        }
    }

    public static class Row
    extends Vector<Atom> {
        public final int globalCounter;

        Row(Vector<Token> tokens, TreeMap<String, Order> orders) throws RuleParseException {
            int gc = -1;
            boolean first = true;
            while (tokens.size() > 0) {
                Expression ex = Expression.mkCounterOrAtom(tokens);
                if (first) {
                    first = false;
                    if (ex instanceof Expression.Star) {
                        gc = -1;
                        continue;
                    }
                    if (ex instanceof Expression.Num) {
                        gc = ((Expression.Num)ex).nVal;
                        continue;
                    }
                }
                if (!(ex instanceof Expression.ParenList)) {
                    throw new RuleParseException("Expected a paren list; found " + ex);
                }
                Expression.ParenList pex = (Expression.ParenList)ex;
                this.add(new Atom(pex, orders));
            }
            this.globalCounter = gc;
        }

        @Override
        public String toString() {
            return "(globalCounter=" + this.globalCounter + ") " + Util.joinNonBlank(" ", this);
        }

        public String toSrc() {
            Vector<Object> v = new Vector<Object>();
            if (this.globalCounter > 0) {
                v.add("" + this.globalCounter);
            }
            for (Atom atom : this) {
                v.add(atom.toSrc());
            }
            return String.join((CharSequence)" ", v);
        }

        void forceOrder(String orderName) {
            for (Atom atom : this) {
                atom.forceOrder(orderName);
            }
        }

        HashSet<Piece.Shape> listAllShapes() {
            HashSet<Piece.Shape> h = new HashSet<Piece.Shape>();
            for (Atom atom : this) {
                if (atom.shapes == null) continue;
                for (Piece.Shape shape : atom.shapes) {
                    h.add(shape);
                }
            }
            return h;
        }

        HashSet<Piece.Color> listAllColors() {
            HashSet<Piece.Color> h = new HashSet<Piece.Color>();
            for (Atom atom : this) {
                if (atom.colors == null) continue;
                for (Piece.Color color : atom.colors) {
                    h.add(color);
                }
            }
            return h;
        }

        TreeMap<String, TreeSet<String>> listAllPropValues() {
            TreeMap<String, TreeSet<String>> propValues = new TreeMap<String, TreeSet<String>>();
            for (Atom atom : this) {
                for (String p : atom.propertyConditions.keySet()) {
                    TreeSet<String> h = propValues.get(p);
                    if (h == null) {
                        h = new TreeSet();
                        propValues.put(p, h);
                    }
                    PropertyCondition cond = atom.propertyConditions.get(p);
                    h.addAll(cond.acceptedValues);
                }
            }
            return propValues;
        }
    }

    public static class Atom {
        public final int counter;
        public final Piece.Shape[] shapes;
        public Piece.Color[] colors;
        public PositionList plist;
        public BucketList bucketList;
        HashMap<String, PropertyCondition> propertyConditions = new HashMap();

        public String toString() {
            return "(" + this.counter + "," + Atom.showList(this.shapes) + "," + Atom.showList(this.colors) + "," + this.plist + "," + this.bucketList + ")";
        }

        private static <T> String showList(T[] v) {
            if (v == null) {
                return "*";
            }
            Vector<String> w = new Vector<String>();
            for (T t : v) {
                Object s = t.toString();
                if (((String)s).indexOf("/") >= 0) {
                    s = "\"" + (String)s + "\"";
                }
                w.add((String)s);
            }
            Object q = String.join((CharSequence)",", w);
            if (v.length != 1) {
                q = "[" + (String)q + "]";
            }
            return q;
        }

        private boolean hasNonSCCond() {
            for (String key : this.propertyConditions.keySet()) {
                if (key.equals("shape") || key.equals("color")) continue;
                return true;
            }
            return false;
        }

        public String toSrc() {
            if (this.hasNonSCCond()) {
                Vector<CallSite> v = new Vector<CallSite>();
                v.add((CallSite)((Object)("count:" + (String)(this.counter < 0 ? "*" : "" + this.counter))));
                for (String key : this.propertyConditions.keySet()) {
                    v.add((CallSite)((Object)(key + ":" + this.propertyConditions.get(key))));
                }
                v.add((CallSite)((Object)("pos:" + this.plist.toSrc())));
                v.add((CallSite)((Object)("bucket:" + this.bucketList.toSrc())));
                return "(" + String.join((CharSequence)", ", v) + ")";
            }
            return "(" + (String)(this.counter < 0 ? "*" : "" + this.counter) + "," + Atom.showList(this.shapes) + "," + Atom.showList(this.colors) + "," + this.plist.toSrc() + "," + this.bucketList.toSrc() + ")";
        }

        Atom(Expression.ParenList pex, TreeMap<String, Order> orders) throws RuleParseException {
            String s;
            Vector<Piece.PseudoEnum> w;
            String s2;
            int colonCnt = 0;
            for (Expression g : pex) {
                if (!(g instanceof Expression.ColonExpression)) continue;
                ++colonCnt;
            }
            boolean colonized = colonCnt == pex.size();
            HashMap<String, Expression> arms = new HashMap<String, Expression>();
            if (colonized) {
                for (Object _g : pex) {
                    Expression.ColonExpression g = (Expression.ColonExpression)_g;
                    String key = g.prefix.toString();
                    if (arms.get(key) != null) {
                        throw new RuleParseException("An atom has multiple clauses with the same prefix '" + key + "'");
                    }
                    arms.put(key, g.arex);
                }
            } else {
                if (colonCnt > 0) {
                    throw new RuleParseException("An atom must not combine colon-based and colon-less clauses: size=" + pex.size() + ": " + pex);
                }
                if (pex.size() != 5) {
                    throw new RuleParseException("Expected either a 'colonized' tuple or a tuple with 5 elements; found " + pex.size() + ": " + pex);
                }
                arms.put("count", (Expression)pex.get(0));
                arms.put("shape", (Expression)pex.get(1));
                arms.put("color", (Expression)pex.get(2));
                arms.put("pos", (Expression)pex.get(3));
                arms.put("bucket", (Expression)pex.get(4));
            }
            Expression g = (Expression)arms.remove("count");
            if (g == null || g instanceof Expression.Star) {
                this.counter = -1;
            } else if (g instanceof Expression.Num) {
                this.counter = ((Expression.Num)g).nVal;
            } else {
                throw new RuleParseException("Counter is not a star or number: " + pex);
            }
            g = (Expression)arms.remove("pos");
            this.plist = new PositionList(g, orders);
            g = (Expression)arms.remove("bucket");
            if (g instanceof Expression.ArithmeticExpression) {
                this.bucketList = new BucketList((Expression.ArithmeticExpression)g);
            } else if (g instanceof Expression.Star || g == null) {
                this.bucketList = new BucketList((Expression.Star)g);
            } else {
                throw new RuleParseException("Buckets must be specified by a bracket list. Instead, found " + g + " in: " + pex);
            }
            for (String key : arms.keySet()) {
                g = (Expression)arms.get(key);
                if (g instanceof Expression.Star) continue;
                PropertyCondition cond = new PropertyCondition();
                if (g instanceof Expression.Id || g instanceof Expression.Num) {
                    if (g instanceof Expression.QualifiedId) {
                        throw new RuleParseException("Cannot use Id.Id (" + g + ") for prop values");
                    }
                    cond.add(g.toString());
                } else if (g instanceof Expression.BracketList) {
                    for (Expression h : (Expression.BracketList)g) {
                        if (h instanceof Expression.Id || h instanceof Expression.Num) {
                            if (h instanceof Expression.QualifiedId) {
                                throw new RuleParseException("Cannot use Id.Id (" + h + ") for shapes");
                            }
                            cond.add(h.toString());
                            continue;
                        }
                        throw new RuleParseException("Invalid value list element (" + h + ") for property " + key + " in: " + pex);
                    }
                } else if (g instanceof Expression.RangeExpression) {
                    Expression.RangeExpression r = (Expression.RangeExpression)g;
                    cond.addRange(r.a0.nVal, r.a1.nVal);
                } else {
                    throw new RuleParseException("Invalid value (" + g + ") for property " + key + " in: " + pex);
                }
                this.propertyConditions.put(key, cond);
            }
            g = (Expression)arms.remove("shape");
            if (g == null || g instanceof Expression.Star) {
                this.shapes = null;
            } else if (g instanceof Expression.Id) {
                if (g instanceof Expression.QualifiedId) {
                    throw new RuleParseException("Cannot use Id.Id (" + g + ")  for shapes");
                }
                s2 = g.toString();
                this.shapes = new Piece.Shape[]{Piece.Shape.findShape(s2)};
            } else if (g instanceof Expression.BracketList) {
                w = new Vector<Piece.PseudoEnum>();
                for (Expression h : (Expression.BracketList)g) {
                    if (h instanceof Expression.Id) {
                        if (h instanceof Expression.QualifiedId) {
                            throw new RuleParseException("Cannot use Id.Id (" + h + ") for shapes");
                        }
                        s = h.toString();
                        w.add(Piece.Shape.findShape(s));
                        continue;
                    }
                    throw new RuleParseException("Invalid shape (" + h + ") in: " + pex);
                }
                this.shapes = w.toArray(new Piece.Shape[0]);
            } else {
                throw new RuleParseException("Invalid shape (" + g + ") in: " + pex);
            }
            g = (Expression)arms.remove("color");
            if (g == null || g instanceof Expression.Star) {
                this.colors = null;
            } else if (g instanceof Expression.Id) {
                s2 = g.toString();
                this.colors = new Piece.Color[]{Piece.Color.findColor(s2)};
            } else if (g instanceof Expression.BracketList) {
                w = new Vector();
                for (Expression h : (Expression.BracketList)g) {
                    if (h instanceof Expression.Id) {
                        s = h.toString();
                        w.add(Piece.Color.findColor(s));
                        continue;
                    }
                    throw new RuleParseException("Invalid color (" + h + ") in: " + pex);
                }
                this.colors = w.toArray(new Piece.Color[0]);
            } else {
                throw new RuleParseException("Invalid color (" + g + ") in: " + pex);
            }
        }

        void forceOrder(String orderName) {
            this.plist.forceOrder(orderName);
        }

        boolean acceptsShape(Piece.Shape x) {
            if (this.shapes == null) {
                return true;
            }
            for (Piece.Shape y : this.shapes) {
                if (x != y) continue;
                return true;
            }
            return false;
        }

        boolean acceptsColor(Piece.Color x) {
            if (this.colors == null) {
                return true;
            }
            for (Piece.Color y : this.colors) {
                if (x != y) continue;
                return true;
            }
            return false;
        }

        public boolean acceptsColorShapeAndProperties(Piece p) {
            ImageObject io = p.getImageObject();
            if (io == null) {
                return this.acceptsShape(p.xgetShape()) && this.acceptsColor(p.xgetColor());
            }
            for (String key : this.propertyConditions.keySet()) {
                PropertyCondition cond = this.propertyConditions.get(key);
                String s = (String)io.get(key);
                if (s != null && cond.accepts(s)) continue;
                return false;
            }
            return true;
        }
    }

    private static class PropertyCondition {
        HashSet<String> acceptedValues = new HashSet();
        HashSet<Range> acceptedRanges = new HashSet();

        private PropertyCondition() {
        }

        boolean accepts(String s) {
            if (s.equals("*") || this.acceptedValues.contains(s)) {
                return true;
            }
            try {
                int x = Integer.parseInt(s);
                for (Range r : this.acceptedRanges) {
                    if (!r.contains(x)) continue;
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return false;
        }

        void add(String s) {
            this.acceptedValues.add(s);
        }

        void addRange(int a0, int a1) {
            this.acceptedRanges.add(new Range(a0, a1));
        }

        public String toString() {
            Vector<String> v = new Vector<String>();
            v.addAll(this.acceptedValues);
            for (Range r : this.acceptedRanges) {
                v.add(r.toString());
            }
            Object s = String.join((CharSequence)", ", v);
            if (v.size() != 1) {
                s = "[" + (String)s + "]";
            }
            return s;
        }
    }

    private static class Range {
        int a0;
        int a1;

        Range(int _a0, int _a1) {
            this.a0 = _a0;
            this.a1 = _a1;
        }

        boolean contains(int x) {
            return this.a0 <= x && x <= this.a1;
        }

        public String toString() {
            return "[" + this.a0 + ".." + this.a1 + "]";
        }
    }

    public static class BucketList
    extends Vector<Expression.ArithmeticExpression> {
        BucketList(Expression.Star star) throws RuleParseException {
            for (int j = 0; j < 4; ++j) {
                this.add(new Expression.Num(j));
            }
        }

        BucketList(Expression.ArithmeticExpression num) {
            this.add(num);
        }

        @Override
        public String toString() {
            return "[" + Util.joinNonBlank(",", this) + "]";
        }

        public String toSrc() {
            Vector<String> v = new Vector<String>();
            for (Expression.ArithmeticExpression ex : this) {
                v.add(ex.toSrc());
            }
            Object s = String.join((CharSequence)",", v);
            if (v.size() > 1) {
                s = "[" + (String)s + "]";
            }
            return s;
        }

        public BitSet destinations(HashMap<String, HashSet<Integer>> varMap) {
            BitSet q = new BitSet(Board.buckets.length);
            for (Expression.ArithmeticExpression ae : this) {
                HashSet<Integer> h = ae.evalSet(varMap);
                h = Expression.moduloNB(h);
                q.or(Util.toBitSet(h));
            }
            return q;
        }
    }

    public static class PositionList {
        private boolean any;
        Vector<Integer> list1 = new Vector();
        Vector<String> list2 = new Vector();

        public String toString() {
            return "[" + Util.joinNonBlank(",", this.list1) + "; " + Util.joinNonBlank(",", this.list2) + "]";
        }

        public String toSrc() {
            if (this.any) {
                return "*";
            }
            String[] q = new String[]{Util.joinNonBlank(",", this.list1), Util.joinNonBlank(",", this.list2)};
            Object s = Util.joinNonBlank(",", q);
            if (this.list1.size() + this.list2.size() > 1) {
                s = "[" + (String)s + "]";
            }
            return s;
        }

        private void addAll(PositionList q) throws RuleParseException {
            if (this.any || q.any) {
                throw new RuleParseException("When describing position lists, '*' cannot be used in combinations");
            }
            this.list1.addAll(q.list1);
            this.list2.addAll(q.list2);
        }

        PositionList(Expression ex, TreeMap<String, Order> orders) throws RuleParseException {
            boolean bl = this.any = ex == null || ex instanceof Expression.Star;
            if (this.any) {
                return;
            }
            if (ex instanceof Expression.BracketList) {
                for (Expression z : (Expression.BracketList)ex) {
                    this.addAll(new PositionList(z, orders));
                }
            } else if (ex instanceof Expression.Num) {
                this.list1.add(((Expression.Num)ex).nVal);
            } else if (ex instanceof Expression.Id) {
                String s = ex.toString();
                if (!orders.containsKey(s) && Order.predefinedOrders.containsKey(s)) {
                    orders.put(s, Order.predefinedOrders.get(s));
                }
                this.list2.add(s);
            } else {
                throw new RuleParseException("Invalid position specifier: " + ex);
            }
            if (this.list1.size() == 0 && this.list2.size() == 0) {
                throw new RuleParseException("No position list specified! ex=" + ex);
            }
        }

        public boolean allowsPicking(int pos, HashMap<String, BitSet> eligibleForEachOrder) {
            if (this.any) {
                return true;
            }
            Iterator<Object> iterator = this.list1.iterator();
            while (iterator.hasNext()) {
                int k = iterator.next();
                if (k != pos) continue;
                return true;
            }
            for (String orderName : this.list2) {
                BitSet eligible = eligibleForEachOrder.get(orderName);
                if (eligible == null) {
                    throw new IllegalArgumentException("Unknown order name (" + orderName + ") - should have been caught before!");
                }
                if (!eligible.get(pos)) continue;
                return true;
            }
            return false;
        }

        void forceOrder(String orderName) {
            if (this.any) {
                this.any = false;
                if (this.list1.size() > 0 || this.list2.size() > 0) {
                    throw new IllegalArgumentException("Cannot force an order on this PositionList, because it is already non-empty");
                }
                this.list2.add(orderName);
            }
        }
    }

    public static enum BucketSelector {
        p,
        pc,
        ps,
        Nearby,
        Remotest;

    }
}

