/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.formatter;

import edu.wisc.game.formatter.Fmter;
import edu.wisc.game.util.Util;
import java.io.File;
import java.io.IOException;

public class HTMLFmter
extends Fmter {
    private String css = null;
    private int formCnt = 0;
    public static HTMLFmter htmlFmter = new HTMLFmter(null);

    public HTMLFmter(File cssFile) {
        this.html = true;
        try {
            this.css = cssFile != null ? Util.readTextFile(cssFile) : null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String style() {
        return this.css == null ? "" : this.wrap2("style", "type=\"text/css\"", this.css) + "\n";
    }

    @Override
    public String br() {
        return "<br>\n";
    }

    @Override
    public String hr() {
        return "<hr>\n";
    }

    @Override
    public String hrThin() {
        return "<hr class=\"thin\">\n";
    }

    @Override
    public String space(int n) {
        String z = "&nbsp;";
        StringBuffer b = new StringBuffer(6 * n);
        for (int i = 0; i < n; ++i) {
            b.append(z);
        }
        return b.toString();
    }

    @Override
    public String wrap(String wrap, String extra, String text) {
        Object wrapStart = wrap;
        if (extra != null && extra.length() > 0) {
            wrapStart = (String)wrapStart + " " + extra;
        }
        return "<" + (String)wrapStart + ">" + text + "</" + wrap + ">";
    }

    @Override
    public String wrap(String wrap, String text) {
        return this.wrap(wrap, null, text);
    }

    public String input(String name, String value, int size) {
        String s = "<input name='" + name + "' type='text'";
        if (value != null) {
            s = s + " value='" + value + "'";
        }
        if (size > 0) {
            s = s + " size='" + size + "'";
        }
        s = s + ">";
        return s;
    }

    public String input(String name, String value) {
        return this.input(name, value, 0);
    }

    public String input(String name) {
        return this.input(name, null, 0);
    }

    public String hidden(String name, String value) {
        return "<input type='hidden' name='" + name + "' value='" + value + "'>\n";
    }

    public void resetFormCnt() {
        this.formCnt = 0;
    }

    @Override
    public String colored(String col, String text) {
        if (col.equals("yellow")) {
            col = "orange";
        }
        return (String)(this.color ? "<span style=\"color:" + col + "\">" : "<span>") + text + "</span>";
    }

    public String html(String title, String body) {
        return this.wrap("html", this.wrap("head", this.wrap("title", title)) + "\n" + this.wrap("body", body));
    }

    @Override
    public String a(String url, String text, String extraClauses) {
        String s = "<a href=\"" + url + "\"";
        if (extraClauses != null) {
            s = s + " " + extraClauses;
        }
        s = s + ">" + text + "</a>";
        return s;
    }
}

