/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.parser;

import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.parser.Token;
import edu.wisc.game.sql.Episode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public interface Expression {
    public static final Star STAR = new Star();

    public String toSrc();

    public static Expression mkCounterOrAtom(Vector<Token> tokens) throws RuleParseException {
        if (tokens.size() == 0) {
            throw new RuleParseException("Unexpected end of expression");
        }
        Token a = tokens.remove(0);
        if (a.equals(Token.STAR)) {
            return STAR;
        }
        if (a.type == Token.Type.NUMBER) {
            return new Num(a);
        }
        if (a.type == Token.Type.OPEN && a.cVal == '(') {
            Vector<Expression> v = new Vector<Expression>();
            while (!tokens.isEmpty()) {
                a = tokens.get(0);
                if (a.equals(Token.STAR)) {
                    tokens.remove(0);
                    v.add(new Star());
                } else if (v.size() != 0 || a.type != Token.Type.CLOSE || a.cVal != ')') {
                    if (tokens.size() >= 2 && a.type == Token.Type.ID && tokens.get((int)1).type == Token.Type.COLON) {
                        Id prefix = new Id(a);
                        tokens.remove(0);
                        tokens.remove(0);
                        Expression y = Expression.mkRangeExpression(tokens);
                        if (y == null) {
                            y = Expression.mkLongestArithmeticExpression(tokens);
                        }
                        v.add(new ColonExpression(prefix, y));
                    } else {
                        v.add(Expression.mkLongestArithmeticExpression(tokens));
                    }
                }
                if (tokens.isEmpty()) {
                    throw new RuleParseException("Unexpected end of a paren list expression");
                }
                Token b = tokens.get(0);
                if (b.type == Token.Type.COMMA) {
                    tokens.remove(0);
                    continue;
                }
                if (b.type == Token.Type.CLOSE && b.cVal == ')') {
                    tokens.remove(0);
                    return new ParenList(v);
                }
                throw new RuleParseException("Unexpected end of a parenthesized list: instead of a comma or a closing paren, found " + b);
            }
            throw new RuleParseException("Unexpected end of a parenthesized list: line ended without closing paren");
        }
        throw new RuleParseException("Expected a counter or an atom (a paren list), found " + a);
    }

    private static RangeExpression mkRangeExpression(Vector<Token> tokens) throws RuleParseException {
        if (tokens.size() < 5) {
            return null;
        }
        if (tokens.get((int)0).type != Token.Type.OPEN || tokens.get((int)0).cVal != '[') {
            return null;
        }
        if (tokens.get((int)1).type != Token.Type.NUMBER) {
            return null;
        }
        if (!tokens.get(2).equals(Token.DOTDOT)) {
            return null;
        }
        if (tokens.get((int)3).type != Token.Type.NUMBER) {
            return null;
        }
        if (tokens.get((int)4).type != Token.Type.CLOSE || tokens.get((int)4).cVal != ']') {
            return null;
        }
        tokens.remove(0);
        Num a0 = new Num(tokens.remove(0));
        tokens.remove(0);
        Num a1 = new Num(tokens.remove(0));
        tokens.remove(0);
        return new RangeExpression(a0, a1);
    }

    public static ArithmeticExpression mkLongestArithmeticExpression(Vector<Token> tokens) throws RuleParseException {
        return Expression.mkLongestE5(tokens);
    }

    private static ArithmeticExpression mkLongestE5(Vector<Token> tokens) throws RuleParseException {
        if (tokens.size() == 0) {
            throw new RuleParseException("Unexpected end of line. (Expected an E5-type arithmetic expression)");
        }
        ArithmeticExpression q = Expression.mkLongestE4(tokens);
        if (tokens.size() == 0) {
            return q;
        }
        Token a = tokens.firstElement();
        if (!a.equals(Token.EQQ)) {
            return q;
        }
        tokens.remove(0);
        ArithmeticExpression q2 = Expression.mkLongestE4(tokens);
        return new EqualityExpression(q, q2);
    }

    private static ArithmeticExpression mkLongestE4(Vector<Token> tokens) throws RuleParseException {
        if (tokens.size() == 0) {
            throw new RuleParseException("Unexpected end of line. (Expected an E4-type arithmetic expression)");
        }
        ArithmeticExpression q = Expression.mkLongestE3(tokens);
        AdditiveExpression y = new AdditiveExpression(q);
        while (tokens.size() > 0 && tokens.firstElement().type == Token.Type.ADD_OP) {
            y.ops.add(tokens.remove(0));
            if (tokens.isEmpty()) {
                throw new RuleParseException("Unexpected end of additive expression");
            }
            ArithmeticExpression b = Expression.mkLongestE3(tokens);
            y.add(b);
        }
        return y.size() > 1 ? y : q;
    }

    private static ArithmeticExpression mkLongestE3(Vector<Token> tokens) throws RuleParseException {
        if (tokens.size() == 0) {
            throw new RuleParseException("Unexpected end of line. (Expected an E3-type arithmetic expression)");
        }
        ArithmeticExpression q = Expression.mkLongestE2(tokens);
        MultiplicativeExpression y = new MultiplicativeExpression(q);
        while (tokens.size() > 0 && tokens.firstElement().type == Token.Type.MULT_OP) {
            y.ops.add(tokens.remove(0));
            if (tokens.isEmpty()) {
                throw new RuleParseException("Unexpected end of additive expression");
            }
            ArithmeticExpression b = Expression.mkLongestE2(tokens);
            y.add(b);
        }
        return y.size() > 1 ? y : q;
    }

    private static ArithmeticExpression mkLongestE2(Vector<Token> tokens) throws RuleParseException {
        if (tokens.size() == 0) {
            throw new RuleParseException("Unexpected end of line. (Expected an E2-type arithmetic expression)");
        }
        if (tokens.firstElement().equals(Token.BANG)) {
            tokens.remove(0);
            ArithmeticExpression q = Expression.mkLongestE2(tokens);
            return new NegationExpression(q);
        }
        return Expression.mkLongestE1(tokens);
    }

    public static ArithmeticExpression mkLongestE1(Vector<Token> tokens) throws RuleParseException {
        if (tokens.size() == 0) {
            throw new RuleParseException("Unexpected end of line. (Expected an E1-type arithmetic expression)");
        }
        Token a = tokens.firstElement();
        if (a.type == Token.Type.ID) {
            tokens.remove(0);
            if (tokens.size() >= 2 && tokens.get((int)0).type == Token.Type.DOT && tokens.get((int)1).type == Token.Type.ID) {
                tokens.remove(0);
                Token b = tokens.firstElement();
                tokens.remove(0);
                return new QualifiedId(a, b);
            }
            return new Id(a);
        }
        if (a.type == Token.Type.STRING) {
            tokens.remove(0);
            return new Id(a);
        }
        if (a.type == Token.Type.NUMBER) {
            tokens.remove(0);
            return new Num(a);
        }
        if (a.type == Token.Type.OPEN && a.cVal == '(') {
            tokens.remove(0);
            ArithmeticExpression q = Expression.mkLongestArithmeticExpression(tokens);
            if (tokens.size() == 0) {
                throw new RuleParseException("Unexpected end of a parenthesized expression");
            }
            Token b = tokens.firstElement();
            if (b.type == Token.Type.CLOSE && b.cVal == ')') {
                tokens.remove(0);
                return q;
            }
            throw new RuleParseException("Unexpected end of a parenthesized expression: instead of a closing paren, found " + b);
        }
        if (a.type == Token.Type.OPEN && a.cVal == '[') {
            return Expression.mkBracketList(tokens);
        }
        throw new RuleParseException("Expected primitive or (arithmetic) or [list], but instead found " + a);
    }

    public static BracketList mkBracketList(Vector<Token> tokens) throws RuleParseException {
        if (tokens.size() == 0) {
            throw new RuleParseException("Unexpected end of line. (Expected a bracket list [...]");
        }
        Token a = tokens.firstElement();
        if (a.type == Token.Type.OPEN && a.cVal == '[') {
            tokens.remove(0);
            Vector<Expression> v = new Vector<Expression>();
            while (tokens.size() > 0) {
                ArithmeticExpression z = Expression.mkLongestArithmeticExpression(tokens);
                v.add(z);
                if (tokens.size() == 0) {
                    throw new RuleParseException("Unexpected end of bracket list");
                }
                Token b = tokens.firstElement();
                if (b.type == Token.Type.COMMA) {
                    tokens.remove(0);
                    continue;
                }
                if (b.type == Token.Type.CLOSE && b.cVal == ']') {
                    tokens.remove(0);
                    return new BracketList(v);
                }
                throw new RuleParseException("Expected ']', found " + b);
            }
            throw new RuleParseException("Unexpected end of bracket list");
        }
        throw new RuleParseException("Expected [list], but instead found " + a);
    }

    public static HashSet<Integer> moduloNB(Set<Integer> h0) {
        HashSet<Integer> h = new HashSet<Integer>();
        for (int x : h0) {
            if ((x %= Episode.NBU) < 0) {
                x += Episode.NBU;
            }
            h.add(x);
        }
        return h;
    }

    public static class Star
    implements Expression {
        public String toString() {
            return "*";
        }

        @Override
        public String toSrc() {
            return this.toString();
        }
    }

    public static class RangeExpression
    implements Expression {
        public final Num a0;
        public final Num a1;

        RangeExpression(Num _a0, Num _a1) {
            this.a0 = _a0;
            this.a1 = _a1;
        }

        @Override
        public String toSrc() {
            return "[" + this.a0.toSrc() + ".." + this.a1.toSrc() + "]";
        }

        public String toString() {
            return this.toSrc();
        }
    }

    public static class ColonExpression
    implements Expression {
        public final Id prefix;
        public final Expression arex;

        ColonExpression(Id _prefix, Expression _arex) {
            this.prefix = _prefix;
            this.arex = _arex;
        }

        @Override
        public String toSrc() {
            return this.prefix.toSrc() + ":" + this.arex.toSrc();
        }

        public String toString() {
            return this.prefix.toString() + ":" + this.arex.toString();
        }
    }

    public static class MultiplicativeExpression
    extends SerialExpression {
        MultiplicativeExpression() {
        }

        MultiplicativeExpression(ArithmeticExpression x) {
            this.add(x);
        }
    }

    public static class AdditiveExpression
    extends SerialExpression {
        AdditiveExpression() {
        }

        AdditiveExpression(ArithmeticExpression x) {
            this.add(x);
        }
    }

    public static class EqualityExpression
    extends SerialExpression {
        EqualityExpression(ArithmeticExpression a, ArithmeticExpression b) {
            this.add(a);
            this.add(b);
            this.ops.add(Token.EQQ);
        }

        @Override
        public HashSet<Integer> evalSet(HashMap<String, HashSet<Integer>> hh) {
            HashSet<Integer> hs0 = ((ArithmeticExpression)this.get(0)).evalSet(hh);
            HashSet<Integer> hs1 = ((ArithmeticExpression)this.get(1)).evalSet(hh);
            if (hs0.size() == 0 || hs1.size() == 0) {
                return hs0;
            }
            boolean e = false;
            for (Integer s : hs0) {
                for (Integer q : hs1) {
                    e = e || s != null && q != null && s.equals(q);
                }
            }
            HashSet<Integer> hr = new HashSet<Integer>();
            if (e) {
                hr.add(1);
            }
            return hr;
        }
    }

    public static abstract class SerialExpression
    extends Vector<ArithmeticExpression>
    implements ArithmeticExpression {
        Vector<Token> ops = new Vector();

        @Override
        public String toString() {
            Vector<String> v = new Vector<String>();
            v.add(((ArithmeticExpression)this.firstElement()).toString());
            for (int j = 0; j < this.ops.size(); ++j) {
                v.add(this.ops.get(j).toString());
                v.add(((ArithmeticExpression)this.get(j + 1)).toString());
            }
            return "{" + String.join((CharSequence)" ", v) + "}";
        }

        @Override
        public String toSrc() {
            Vector<String> v = new Vector<String>();
            v.add(((ArithmeticExpression)this.firstElement()).toSrc());
            for (int j = 0; j < this.ops.size(); ++j) {
                v.add(this.ops.get(j).toSrc());
                v.add(((ArithmeticExpression)this.get(j + 1)).toSrc());
            }
            Object s = String.join((CharSequence)" ", v);
            if (v.size() > 1) {
                s = "(" + (String)s + ")";
            }
            return s;
        }

        @Override
        public HashSet<String> listAllVars() {
            HashSet<String> h = new HashSet<String>();
            for (ArithmeticExpression a : this) {
                h.addAll(a.listAllVars());
            }
            return h;
        }

        @Override
        public HashSet<Integer> evalSet(HashMap<String, HashSet<Integer>> hh) {
            HashSet<Integer> hs = ((ArithmeticExpression)this.firstElement()).evalSet(hh);
            for (int j = 1; j < this.size(); ++j) {
                if (hs.size() == 0) {
                    return hs;
                }
                HashSet<Integer> hq = ((ArithmeticExpression)this.get(j)).evalSet(hh);
                if (hq.size() == 0) {
                    return hq;
                }
                Token op = this.ops.get(j - 1);
                HashSet<Integer> hr = new HashSet<Integer>();
                for (Integer s : hs) {
                    for (Integer q : hq) {
                        int r;
                        if (q == 0 && (op.cVal == '/' || op.cVal == '%')) continue;
                        if (op.equals(Token.EQQ)) {
                            if (!s.equals(q)) continue;
                            r = 1;
                        } else if (op.cVal == '+') {
                            r = s + q;
                        } else if (op.cVal == '-') {
                            r = s - q;
                        } else if (op.cVal == '*') {
                            r = s * q;
                        } else if (op.cVal == '/') {
                            r = s / q;
                        } else if (op.cVal == '%') {
                            r = s % q;
                        } else {
                            throw new IllegalArgumentException("Illegal operation " + op + " in an additive or multiplicative expression");
                        }
                        hr.add(r);
                    }
                }
                hs = hr;
            }
            return hs;
        }
    }

    public static class NegationExpression
    implements ArithmeticExpression {
        final ArithmeticExpression body;

        NegationExpression(ArithmeticExpression _body) {
            this.body = _body;
        }

        public String toString() {
            return "{!" + this.body + "}";
        }

        @Override
        public String toSrc() {
            return "!" + this.body.toSrc();
        }

        @Override
        public HashSet<String> listAllVars() {
            return this.body.listAllVars();
        }

        @Override
        public HashSet<Integer> evalSet(HashMap<String, HashSet<Integer>> hh) {
            HashSet<Integer> hs = this.body.evalSet(hh);
            HashSet<Integer> h = new HashSet<Integer>();
            if (hs.isEmpty()) {
                h.add(1);
            }
            return h;
        }
    }

    public static class QualifiedId
    extends Id {
        public final Id prefix;

        QualifiedId(Token t1, Token t2) throws RuleParseException {
            super(t2);
            this.prefix = new Id(t1);
        }

        @Override
        public HashSet<Integer> evalSet(HashMap<String, HashSet<Integer>> h) {
            HashSet q = h.get(this.prefix + "." + this.sVal);
            return q == null ? new HashSet() : q;
        }

        @Override
        public String toString() {
            return this.prefix.toString() + "." + super.toString();
        }
    }

    public static class Id
    implements ArithmeticExpression {
        public final String sVal;
        final boolean quoted;

        Id(Token t) throws RuleParseException {
            if (t.type != Token.Type.ID && t.type != Token.Type.STRING) {
                throw new RuleParseException("Not an id");
            }
            this.sVal = t.sVal;
            this.quoted = t.type == Token.Type.STRING;
        }

        @Override
        public HashSet<Integer> evalSet(HashMap<String, HashSet<Integer>> h) {
            HashSet q = h.get(this.sVal);
            return q == null ? new HashSet() : q;
        }

        public String toString() {
            return this.sVal;
        }

        @Override
        public String toSrc() {
            return this.quoted ? "\"" + this.toString() + "\"" : this.toString();
        }

        @Override
        public HashSet<String> listAllVars() {
            HashSet<String> h = new HashSet<String>();
            h.add(this.toString());
            return h;
        }
    }

    public static class Num
    implements ArithmeticExpression {
        public final int nVal;

        Num(Token t) throws RuleParseException {
            if (t.type != Token.Type.NUMBER) {
                throw new RuleParseException("Not a number");
            }
            this.nVal = t.nVal;
        }

        public Num(int n) {
            this.nVal = n;
        }

        @Override
        public HashSet<Integer> evalSet(HashMap<String, HashSet<Integer>> h) {
            HashSet<Integer> hr = new HashSet<Integer>();
            hr.add(this.nVal);
            return hr;
        }

        public String toString() {
            return "" + this.nVal;
        }

        @Override
        public String toSrc() {
            return this.toString();
        }

        @Override
        public HashSet<String> listAllVars() {
            return new HashSet<String>();
        }
    }

    public static interface ArithmeticExpression
    extends Expression {
        public HashSet<Integer> evalSet(HashMap<String, HashSet<Integer>> var1);

        public HashSet<String> listAllVars();
    }

    public static class BracketList
    extends ExList
    implements ArithmeticExpression {
        BracketList(Vector<Expression> v) throws RuleParseException {
            super(v);
            for (Expression x : v) {
                if (x instanceof ArithmeticExpression) continue;
                throw new RuleParseException("A bracket expression must consist of arithmetic expressions only. This one isn't: " + x);
            }
        }

        @Override
        public HashSet<Integer> evalSet(HashMap<String, HashSet<Integer>> h) {
            HashSet<Integer> r = new HashSet<Integer>();
            for (Expression _x : this) {
                ArithmeticExpression x = (ArithmeticExpression)_x;
                r.addAll(x.evalSet(h));
            }
            return r;
        }

        @Override
        public HashSet<String> listAllVars() {
            HashSet<String> r = new HashSet<String>();
            for (Expression _x : this) {
                ArithmeticExpression x = (ArithmeticExpression)_x;
                r.addAll(x.listAllVars());
            }
            return r;
        }

        @Override
        public String toString() {
            return this.toString('[', ']');
        }

        @Override
        public String toSrc() {
            return this.toSrc('[', ']');
        }
    }

    public static class ParenList
    extends ExList {
        ParenList(Vector<Expression> v) {
            super(v);
        }

        @Override
        public String toString() {
            return this.toString('(', ')');
        }

        @Override
        public String toSrc() {
            return this.toSrc('(', ')');
        }
    }

    public static abstract class ExList
    extends Vector<Expression>
    implements Expression {
        ExList(Vector<Expression> v) {
            super(v);
        }

        public String toString(char open, char close) {
            Vector<String> v = new Vector<String>();
            for (Expression e : this) {
                v.add(e.toString());
            }
            return open + String.join((CharSequence)", ", v) + close;
        }

        public String toSrc(char open, char close) {
            Vector<String> v = new Vector<String>();
            for (Expression e : this) {
                v.add(e.toSrc());
            }
            return open + String.join((CharSequence)", ", v) + close;
        }
    }
}

