/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.parser;

import edu.wisc.game.parser.Expression;
import edu.wisc.game.parser.RuleParseException;
import edu.wisc.game.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class Token {
    public final Type type;
    public char cVal = '\u0000';
    public String sVal = null;
    public int nVal = 0;
    static final Token EQQ = new Token(Type.EQQ, "==");
    static final Token DOTDOT = new Token(Type.DOTDOT, "..");
    static final Token BANG = Token.wrapToken('!');
    static final Token STAR = Token.wrapToken('*');

    public String asId() {
        return this.type == Type.ID ? this.sVal : null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Token)) {
            return false;
        }
        Token t = (Token)o;
        return this.type == t.type && this.cVal == t.cVal && this.nVal == t.nVal && Util.same(this.sVal, t.sVal);
    }

    public String toString() {
        return this.type + "." + this.toSrc();
    }

    public String toSrc() {
        return this.type == Type.NUMBER ? "" + this.nVal : (this.type == Type.ID ? this.sVal : (this.type == Type.EQQ ? this.sVal : (this.type == Type.STRING ? "\"" + this.sVal + "\"" : "" + this.cVal)));
    }

    public String toArgv() {
        return this.type == Type.NUMBER ? "" + this.nVal : (this.type == Type.ID ? this.sVal : (this.type == Type.STRING ? this.sVal : (this.type == Type.EQQ ? this.sVal : "" + this.cVal)));
    }

    private Token(char c) throws RuleParseException {
        Type type = Character.isDigit(c) ? Type.NUMBER : (Character.isJavaIdentifierStart(c) ? Type.ID : (c == ',' ? Type.COMMA : (c == ':' ? Type.COLON : (c == '.' ? Type.DOT : (c == '+' || c == '-' ? Type.ADD_OP : (c == '*' || c == '/' || c == '%' ? Type.MULT_OP : (c == '!' ? Type.UNARY_OP : (c == '(' || c == '[' ? Type.OPEN : (c == ')' || c == ']' ? Type.CLOSE : (c == '\"' ? Type.STRING : (this.type = c == '=' ? Type.EQUAL : null)))))))))));
        if (this.type == null) {
            throw new RuleParseException("Illegal character: " + c);
        }
        this.cVal = c;
        this.sVal = this.type == Type.STRING ? "" : "" + c;
    }

    private Token(Type _type, String _sVal) {
        this.type = _type;
        this.sVal = _sVal;
    }

    private static Token wrapToken(char c) {
        try {
            return new Token(c);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void complete() {
        if (this.type == Type.NUMBER) {
            this.nVal = Integer.parseInt(this.sVal);
            this.cVal = '\u0000';
        } else {
            this.cVal = this.type == Type.ID || this.type == Type.STRING || this.type == Type.EQQ || this.type == Type.DOTDOT ? (char)'\u0000' : this.sVal.charAt(0);
        }
    }

    public static Vector<Token> tokenize(String x) throws RuleParseException {
        Tokenizer t = new Tokenizer(x);
        return t.result;
    }

    public static String toString(Vector<Token> tokens) {
        Vector<String> v = new Vector<String>();
        for (Token t : tokens) {
            v.add(t.toString());
        }
        return String.join((CharSequence)" ", v);
    }

    public static void main(String[] argv) throws IOException, RuleParseException {
        String s;
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        h.put("one", 1);
        h.put("two", 2);
        h.put("three", 3);
        h.put("four", 4);
        HashMap<String, HashSet<Integer>> hh = new HashMap<String, HashSet<Integer>>();
        for (String key : h.keySet()) {
            HashSet<Integer> z = new HashSet<Integer>();
            z.add((Integer)h.get(key));
            hh.put(key, z);
        }
        InputStream in = System.in;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(System.in));
        while ((s = reader.readLine()) != null) {
            Vector<Token> q = Token.tokenize(s);
            System.out.println(Token.toString(q));
            try {
                Expression.ArithmeticExpression ex = Expression.mkLongestArithmeticExpression(q);
                System.out.println("E=" + ex);
                System.out.println("Class=" + ex.getClass());
                if (ex instanceof Expression.ArithmeticExpression) {
                    Expression.ArithmeticExpression ae = ex;
                    HashSet<Integer> hv = ae.evalSet(hh);
                    System.out.print("Eval=");
                    for (Integer x : hv) {
                        System.out.print(" " + x);
                    }
                    System.out.println();
                    continue;
                }
                System.out.println("Not an arithmetic expression");
            }
            catch (RuleParseException ex) {
                System.err.println(ex);
                ex.printStackTrace(System.err);
            }
        }
    }

    private static class Tokenizer {
        private final Vector<Token> result = new Vector();
        private Token currentToken = null;
        private boolean commentHasStarted = false;

        Tokenizer(String x) throws RuleParseException {
            for (int i = 0; i < x.length() && !this.commentHasStarted; ++i) {
                this.addC(x.charAt(i));
            }
            this.flush();
        }

        private void flush() {
            if (this.currentToken == null) {
                return;
            }
            this.currentToken.complete();
            this.result.add(this.currentToken);
            this.currentToken = null;
        }

        private void addC(char c) throws RuleParseException {
            if (this.currentToken != null) {
                if (Character.isDigit(c) && this.currentToken.type == Type.NUMBER || Character.isJavaIdentifierPart(c) && this.currentToken.type == Type.ID) {
                    this.currentToken.sVal = this.currentToken.sVal + c;
                    return;
                }
                if (this.currentToken.type == Type.STRING) {
                    if (c == '\"') {
                        this.flush();
                        return;
                    }
                    this.currentToken.sVal = this.currentToken.sVal + c;
                    return;
                }
                if (this.currentToken.type == Type.EQUAL && c == '=') {
                    this.currentToken = EQQ;
                    this.flush();
                    return;
                }
                if (this.currentToken.type == Type.DOT && c == '.') {
                    this.currentToken = DOTDOT;
                    this.flush();
                    return;
                }
                this.flush();
            }
            if (Character.isWhitespace(c)) {
                this.flush();
                return;
            }
            if (c == '#') {
                this.commentHasStarted = true;
                return;
            }
            this.currentToken = new Token(c);
        }
    }

    public static enum Type {
        NUMBER,
        ID,
        STRING,
        COMMA,
        MULT_OP,
        ADD_OP,
        EQQ,
        UNARY_OP,
        OPEN,
        CLOSE,
        EQUAL,
        COLON,
        DOT,
        DOTDOT;

    }
}

