/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.reflect;

import edu.wisc.game.reflect.Reflect;
import edu.wisc.game.util.Logging;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class JsonReflect {
    private final boolean skipNulls;
    private final HashSet<String> excludableNames;

    private JsonValue toJsonValue(Object g) {
        JsonArrayBuilder arrayBuilder = this.toJsonArrayBuider(g);
        JsonArray ar = arrayBuilder.build();
        List list = ar.getValuesAs(JsonValue.class);
        return list.size() > 0 ? (JsonValue)list.get(0) : null;
    }

    private JsonArrayBuilder toJsonArrayBuider(Object g) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        if (g instanceof String) {
            arrayBuilder.add((String)g);
        } else if (g instanceof Integer) {
            arrayBuilder.add(((Integer)g).intValue());
        } else if (g instanceof Long) {
            arrayBuilder.add(((Long)g).longValue());
        } else if (g instanceof Float) {
            arrayBuilder.add((double)((Float)g).floatValue());
        } else if (g instanceof Double) {
            arrayBuilder.add(((Double)g).doubleValue());
        } else if (g instanceof Boolean) {
            arrayBuilder.add(((Boolean)g).booleanValue());
        } else if (g instanceof Enum) {
            arrayBuilder.add(g.toString());
        } else if (g instanceof Date) {
            arrayBuilder.add(JsonReflect.dateToJsonString((Date)g));
        } else if (g.getClass().isArray()) {
            JsonArrayBuilder x = this.doCollection(JsonReflect.arrayX2vector(g));
            arrayBuilder.add(x);
        } else if (g instanceof Collection) {
            JsonArrayBuilder ab = this.doCollection((Collection)g);
            arrayBuilder.add(ab);
        } else if (g instanceof Map) {
            Map h = (Map)g;
            JsonObjectBuilder ob = this.doMap(h);
            arrayBuilder.add(ob);
        } else {
            JsonObjectBuilder ob = this.reflectToJSON(g);
            arrayBuilder.add(ob);
        }
        return arrayBuilder;
    }

    private JsonArrayBuilder doCollection(Collection col) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (Object g : col) {
            if (g == null) {
                if (this.skipNulls) continue;
                arrayBuilder.addNull();
                continue;
            }
            JsonArrayBuilder q = this.toJsonArrayBuider(g);
            arrayBuilder.addAll(q);
        }
        return arrayBuilder;
    }

    private JsonObjectBuilder doMap(Map h) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        for (Object _key : h.keySet()) {
            Object val = h.get(_key);
            String key = _key.toString();
            if (val == null) {
                if (this.skipNulls) continue;
                objectBuilder.addNull(key);
                continue;
            }
            JsonValue q = this.toJsonValue(val);
            objectBuilder.add(key, q);
        }
        return objectBuilder;
    }

    private JsonReflect(boolean _skipNulls, HashSet<String> _excludableNames) {
        this.skipNulls = _skipNulls;
        this.excludableNames = _excludableNames;
    }

    public JsonObjectBuilder reflectToJSON(Object o) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        Reflect r = Reflect.getReflect(o.getClass());
        for (Reflect.Entry e : r.entries) {
            JsonArrayBuilder ab;
            if (this.excludableNames != null && this.excludableNames.contains(e.name)) continue;
            Object val = null;
            try {
                val = e.g.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Logging.error(ex.getMessage());
                val = "ACCESS_ERROR";
            }
            catch (InvocationTargetException ex) {
                Logging.error(ex.getMessage());
                val = "INVOCATION_TARGET_ERROR";
            }
            if (this.skipNulls && (val == null || val.toString().equals("")) || this.skipNulls && e.name.equals("version")) continue;
            Class<?> c = val.getClass();
            if (val == null) {
                if (this.skipNulls) continue;
                objectBuilder.addNull(e.name);
                continue;
            }
            if (c.isArray() && c.isInstance(new int[0])) {
                ab = this.doCollection(JsonReflect.arrayInt2vector((int[])val));
                objectBuilder.add(e.name, ab);
                continue;
            }
            if (c.isArray() && c.isInstance(new double[0])) {
                ab = this.doCollection(JsonReflect.arrayDouble2vector((double[])val));
                objectBuilder.add(e.name, ab);
                continue;
            }
            if (c.isArray()) {
                ab = this.doCollection(JsonReflect.arrayX2vector(val));
                objectBuilder.add(e.name, ab);
                continue;
            }
            JsonValue q = this.toJsonValue(val);
            objectBuilder.add(e.name, q);
        }
        return objectBuilder;
    }

    private static Vector array2vector(Array a) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < Array.getLength(a); ++i) {
            v.add(Array.get(a, i));
        }
        return v;
    }

    private static Vector arrayX2vector(Object a) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < Array.getLength(a); ++i) {
            v.add(Array.get(a, i));
        }
        return v;
    }

    private static Vector arrayInt2vector(int[] a) {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < a.length; ++i) {
            v.add(a[i]);
        }
        return v;
    }

    private static Vector arrayDouble2vector(double[] a) {
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < a.length; ++i) {
            v.add(a[i]);
        }
        return v;
    }

    private static String dateToJsonString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        String output = df.format(date);
        int inset0 = 9;
        int inset1 = 6;
        String s0 = output.substring(0, output.length() - inset0);
        String s1 = output.substring(output.length() - inset1, output.length());
        String result = output;
        return result;
    }

    public static JsonObject reflectToJSONObject(Object o, boolean skipNulls) {
        JsonReflect r = new JsonReflect(skipNulls, null);
        return r.reflectToJSON(o).build();
    }

    public static JsonObject reflectToJSONObject(Object o, boolean skipNulls, HashSet<String> excludableNames) {
        JsonReflect r = new JsonReflect(skipNulls, excludableNames);
        return r.reflectToJSON(o).build();
    }
}

