/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.reflect;

import edu.wisc.game.reflect.Reflect;
import edu.wisc.game.sql.Piece;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonToJava {
    public static Object json2java(JsonObject jo, Object dest) throws ReflectiveOperationException {
        return JsonToJava.doJsonValue((JsonValue)jo, dest, dest.getClass());
    }

    private static Object doJsonValue(JsonValue val, Object z, Type ty) throws ReflectiveOperationException {
        block14: {
            JsonArray q;
            Class c;
            block17: {
                block16: {
                    block15: {
                        block13: {
                            Class valClass;
                            Class clazz = c = z != null ? z.getClass() : (Class)ty;
                            if (!Map.class.isAssignableFrom(c)) break block13;
                            if (!(val instanceof JsonObject)) {
                                throw new IllegalArgumentException("Only JsonObject values can be mapped to Java Maps");
                            }
                            ParameterizedType pty = (ParameterizedType)ty;
                            Type[] fieldArgTypes = pty.getActualTypeArguments();
                            if (fieldArgTypes.length != 2) {
                                throw new IllegalArgumentException("Cannot figure key and value type for map " + c);
                            }
                            Class keyClass = (Class)fieldArgTypes[0];
                            Type valType = fieldArgTypes[1];
                            if (fieldArgTypes[1] instanceof Class) {
                                valClass = (Class)fieldArgTypes[1];
                            } else {
                                ParameterizedType w = (ParameterizedType)valType;
                                valClass = (Class)w.getRawType();
                            }
                            JsonObject jo = (JsonObject)val;
                            for (String key : jo.keySet()) {
                                Object mapKey = JsonToJava.understandJsonString(key, keyClass);
                                JsonValue uval = (JsonValue)jo.get((Object)key);
                                Object w = valClass.newInstance();
                                w = JsonToJava.doJsonValue(uval, w, valType);
                                ((Map)z).put(mapKey, w);
                            }
                            break block14;
                        }
                        if (!JsonToJava.isPrimitive(val)) break block15;
                        z = JsonToJava.understandJsonPrimitive(val, c);
                        break block14;
                    }
                    if (!(val instanceof JsonObject)) break block16;
                    JsonObject jo = (JsonObject)val;
                    Reflect r = Reflect.getReflect(z.getClass());
                    for (String key : jo.keySet()) {
                        JsonValue uval = (JsonValue)jo.get((Object)key);
                        Reflect.Entry e = r.getEntry(key);
                        if (e == null) {
                            System.err.println("json2java: Skipping JSON field: " + key);
                            continue;
                        }
                        Class<?> uc = e.f.getType();
                        Object w = null;
                        try {
                            w = uc.newInstance();
                        }
                        catch (InstantiationException instantiationException) {
                            // empty catch block
                        }
                        if ((w = JsonToJava.doJsonValue(uval, w, e.f.getGenericType())) == null) continue;
                        if (e.s == null) {
                            throw new ReflectiveOperationException("JSON object has a field for which the Java object has no setter method: " + e.name);
                        }
                        e.s.invoke(z, w);
                    }
                    break block14;
                }
                if (!(val instanceof JsonArray)) break block14;
                q = (JsonArray)val;
                if (!c.isArray()) break block17;
                Class<?> cc = c.getComponentType();
                z = Array.newInstance(cc, q.size());
                for (int j = 0; j < q.size(); ++j) {
                    Object w = JsonToJava.doJsonArrayElement(q, j, cc);
                    Array.set(z, j, w);
                }
                break block14;
            }
            if (!Collection.class.isAssignableFrom(c)) break block14;
            Type[] fieldArgTypes = ((ParameterizedType)ty).getActualTypeArguments();
            if (fieldArgTypes.length != 1) {
                throw new IllegalArgumentException("Cannot figure element type for collection " + c);
            }
            Class fieldArgClass = (Class)fieldArgTypes[0];
            z = c.newInstance();
            Collection col = (Collection)z;
            for (int j = 0; j < q.size(); ++j) {
                Object w = JsonToJava.doJsonArrayElement(q, j, fieldArgClass);
                col.add(w);
            }
        }
        return z;
    }

    private static Object doJsonArrayElement(JsonArray q, int j, Class cc) throws ReflectiveOperationException {
        if (Number.class.isAssignableFrom(cc) || JsonToJava.isPrimitiveNumberClass(cc)) {
            return JsonToJava.jsonNumber2java(q.getJsonNumber(j), cc);
        }
        if (cc.isArray() || Collection.class.isAssignableFrom(cc)) {
            return JsonToJava.doJsonValue((JsonValue)q.getJsonArray(j), null, cc);
        }
        Object w = cc.newInstance();
        return JsonToJava.doJsonValue((JsonValue)q.getJsonObject(j), w, cc);
    }

    private static boolean isPrimitive(JsonValue val) {
        return val instanceof JsonNumber || val == JsonValue.TRUE || val == JsonValue.FALSE || val instanceof JsonString;
    }

    static Object understandJsonPrimitive(JsonValue val, Class c) throws ReflectiveOperationException {
        if (val instanceof JsonNumber) {
            return JsonToJava.jsonNumber2java((JsonNumber)val, c);
        }
        if (val == JsonValue.TRUE) {
            return true;
        }
        if (val == JsonValue.FALSE) {
            return false;
        }
        if (val instanceof JsonString) {
            JsonString q = (JsonString)val;
            return JsonToJava.understandJsonString(q, c);
        }
        throw new ReflectiveOperationException("Expected a primitive JSON value, found " + val);
    }

    private static Object jsonNumber2java(JsonNumber q, Class c) {
        Number z = null;
        if (c.isAssignableFrom(Long.class) || c == Long.TYPE) {
            z = q.longValue();
        } else if (c.isAssignableFrom(Integer.class) || c == Integer.TYPE) {
            z = q.intValue();
        } else if (c.isAssignableFrom(Double.class) || c == Double.TYPE) {
            z = q.doubleValue();
        } else if (c.isAssignableFrom(Float.class) || c == Float.TYPE) {
            z = q.doubleValue();
        } else {
            System.err.println("No support for number " + q + " to " + c);
        }
        return z;
    }

    private static boolean isPrimitiveNumberClass(Class c) {
        return c == Long.TYPE || c == Integer.TYPE || c == Double.TYPE || c == Float.TYPE;
    }

    static Object understandJsonString(JsonString q, Class c) throws ReflectiveOperationException {
        return JsonToJava.understandJsonString(q.getString(), c);
    }

    static Object understandJsonString(String s, Class c) throws ReflectiveOperationException {
        if (c.isAssignableFrom(String.class)) {
            return s;
        }
        if (Date.class.isAssignableFrom(c)) {
            try {
                return JsonToJava.parseJsonDate(s);
            }
            catch (ParseException ex) {
                throw new ReflectiveOperationException("Could not parse JSON date: " + s);
            }
        }
        if (Enum.class.isAssignableFrom(c)) {
            return Enum.valueOf(c, s.toUpperCase());
        }
        if (c.isAssignableFrom(Long.class) || c == Long.TYPE) {
            try {
                return new Long(s);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (c.isAssignableFrom(Integer.class) || c == Integer.TYPE) {
            try {
                return new Integer(s);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (c.isAssignableFrom(Double.class) || c == Double.TYPE) {
            try {
                return new Double(s);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (c.isAssignableFrom(Piece.Color.class)) {
            return Piece.Color.findColor(s);
        }
        if (c.isAssignableFrom(Piece.Shape.class)) {
            return Piece.Shape.findShape(s);
        }
        System.err.println("No support for string " + s + " to " + c);
        return null;
    }

    private static Date parseJsonDate(String input) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        if (((String)input).endsWith("Z")) {
            input = ((String)input).substring(0, ((String)input).length() - 1) + "GMT-00:00";
        } else {
            int inset = 6;
            String s0 = ((String)input).substring(0, ((String)input).length() - inset);
            String string = ((String)input).substring(((String)input).length() - inset, ((String)input).length());
        }
        return df.parse((String)input);
    }
}

