/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.reflect;

import edu.wisc.game.reflect.Display;
import edu.wisc.game.reflect.PairFormatter;
import edu.wisc.game.util.Logging;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.xml.bind.annotation.XmlTransient;

public class Reflect {
    public static final DateFormat sqlDf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public Entry[] entries = null;
    private HashMap<String, Entry> entryTable = new HashMap();
    private static HashMap<Class, Reflect> table = new HashMap();

    public static String makeGetMethodName(String name) {
        String capName = name.substring(0, 1).toUpperCase() + name.substring(1);
        return "get" + capName;
    }

    public static String makeGetMethodName2(String name) {
        String capName = name.substring(0, 1).toUpperCase() + name.substring(1);
        return "is" + capName;
    }

    public static String makeSetMethodName(String name) {
        String capName = name.substring(0, 1).toUpperCase() + name.substring(1);
        return "set" + capName;
    }

    public Entry getEntry(String name) {
        return this.entryTable.get(name);
    }

    public Entry getOwningEntry(Enum e) throws IllegalArgumentException {
        Class<?> ec = e.getClass();
        Entry z = null;
        for (Entry entry : this.entries) {
            if (!ec.equals(entry.f.getType())) continue;
            if (z != null) {
                throw new IllegalArgumentException("The class has multiple fields of the enum type of " + e + ": " + z.f + ", " + entry.f);
            }
            z = entry;
        }
        return z;
    }

    public static synchronized Reflect getReflect(Class c) {
        Reflect r;
        Class[] basics;
        for (Class b : basics = new Class[0]) {
            if (!b.isAssignableFrom(c)) continue;
            c = b;
            break;
        }
        if ((r = table.get(c)) == null) {
            r = new Reflect(c);
            table.put(c, r);
        }
        return r;
    }

    private Reflect(Class c) {
        Vector<Entry> v = new Vector<Entry>();
        while (c != null && c != Object.class) {
            for (Field f : c.getDeclaredFields()) {
                Entry e = new Entry();
                e.f = f;
                e.name = f.getName();
                String gn = Reflect.makeGetMethodName(e.name);
                String gn2 = Reflect.makeGetMethodName2(e.name);
                String sn = Reflect.makeSetMethodName(e.name);
                e.s = null;
                e.g = null;
                try {
                    e.g = c.getMethod(gn, new Class[0]);
                    e.s = c.getMethod(sn, e.f.getType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (e.g == null) {
                    try {
                        e.g = c.getMethod(gn2, new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (e.g == null || e.g.getAnnotation(XmlTransient.class) != null) continue;
                Display anno = e.f.getAnnotation(Display.class);
                e.editable = anno != null && anno.editable();
                e.rp = anno != null && anno.rp();
                e.order = anno == null ? 0.0 : anno.order();
                v.addElement(e);
                this.entryTable.put(e.name, e);
            }
            c = c.getSuperclass();
        }
        this.entries = v.toArray(new Entry[v.size()]);
        Arrays.sort(this.entries);
    }

    public static String reflectToString(Object o) {
        return Reflect.reflectToString(o, true);
    }

    public static String compactFormat(Object val) {
        String s;
        if (val == null) {
            return "null";
        }
        if (val instanceof Date) {
            s = sqlDf.format((Date)val);
            String suffix = " 00:00:00";
            if (s.endsWith(" 00:00:00")) {
                s = s.substring(0, s.length() - " 00:00:00".length());
            }
        } else {
            s = val.toString();
        }
        return s;
    }

    public static String reflectToString(Object o, boolean skipNulls) {
        StringBuffer b = new StringBuffer();
        Reflect r = Reflect.getReflect(o.getClass());
        for (Entry e : r.entries) {
            Object val = null;
            try {
                val = e.g.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Logging.error(ex.getMessage());
                val = "ACCESS_ERROR";
            }
            catch (InvocationTargetException ex) {
                Logging.error(ex.getMessage());
                val = "INVOCATION_TARGET_ERROR";
            }
            if (skipNulls && val == null || val.toString().equals("") || skipNulls && e.name.equals("version")) continue;
            b.append(e.name + "=" + Reflect.compactFormat(val) + "; ");
        }
        return b.toString();
    }

    public static String customizedReflect(Object o, PairFormatter f) {
        StringBuffer b = new StringBuffer();
        Reflect r = Reflect.getReflect(o.getClass());
        for (Entry e : r.entries) {
            Object val = null;
            try {
                val = e.g.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Logging.error(ex.getMessage());
                val = "ACCESS_ERROR";
            }
            catch (InvocationTargetException ex) {
                Logging.error(ex.getMessage());
                val = "INVOCATION_TARGET_ERROR";
            }
            if (val == null || val.toString().equals("") || e.name.equals("version")) continue;
            b.append(f.row(e.compactTitle(), Reflect.compactFormat(val)));
        }
        return b.toString();
    }

    public static String csvRow(Object o) {
        return Reflect.csvRow(o, "\n");
    }

    public static String csvRow(Object o, String end) {
        Vector<String> row = Reflect.asStringVector(o, "\"");
        StringBuffer b = new StringBuffer();
        for (String s : row) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(s);
        }
        b.append(end);
        return b.toString();
    }

    public static String htmlRow(Object o, boolean TR) {
        return Reflect.htmlRow(o, TR, true);
    }

    public static String htmlRow(Object o, boolean TR, boolean dolinks) {
        Vector<String> row = Reflect.asStringVector(o, "", dolinks);
        StringBuffer b = new StringBuffer("");
        if (TR) {
            b.append("<tr>");
        }
        for (String s : row) {
            b.append("<td>" + s + "</td>");
        }
        if (TR) {
            b.append("</tr>");
        }
        return b.toString();
    }

    public static String htmlHeaderRow(Class c, boolean TR) {
        StringBuffer b = new StringBuffer("");
        if (TR) {
            b.append("<tr>");
        }
        Reflect r = Reflect.getReflect(c);
        for (Entry e : r.entries) {
            b.append("<th valign=\"top\">" + e.explainedTitle(true) + "</th>");
        }
        if (TR) {
            b.append("</tr>");
        }
        return b.toString();
    }

    public static Vector<String> asStringVector(Object o, String quote) {
        return Reflect.asStringVector(o, quote, false);
    }

    public static Vector<String> asStringVector(Object o, String quote, boolean dolinks) {
        Vector<String> v = new Vector<String>();
        Reflect r = Reflect.getReflect(o.getClass());
        for (Entry e : r.entries) {
            Display anDisplay;
            Object val = null;
            try {
                val = e.g.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Logging.error(ex.getMessage());
                val = "ACCESS_ERROR";
            }
            catch (InvocationTargetException ex) {
                Logging.error(ex.getMessage());
                val = "INVOCATION_TARGET_ERROR";
            }
            Object q = Reflect.formatAsString(val, quote);
            if (!(!dolinks || val instanceof Number && ((Number)val).longValue() <= 0L || (anDisplay = e.f.getAnnotation(Display.class)) == null || anDisplay.link() == null || anDisplay.link().equals(""))) {
                Object url = anDisplay.link();
                if (!((String)url).endsWith("=") && !((String)url).endsWith("/")) {
                    url = (String)url + "?id=";
                }
                url = (String)url + (String)q;
                q = "<a href=\"" + (String)url + "\">" + (String)q + "</a>";
            }
            v.addElement((String)q);
        }
        return v;
    }

    public static String formatAsString(Object val, String quote) {
        Object s;
        boolean needQuotes;
        boolean bl = needQuotes = !(val instanceof Enum) && !(val instanceof Number) && !(val instanceof Boolean);
        if (val == null) {
            return "";
        }
        if (val instanceof Date) {
            s = sqlDf.format((Date)val);
        } else if (val instanceof String) {
            s = (String)val;
            if (((String)s).length() == 1) {
                char x = ((String)s).charAt(0);
                if (x == '\u0000') {
                    s = "false";
                } else if (x == '\u0001') {
                    s = "true";
                }
            }
        } else if (val instanceof Collection) {
            Collection col = (Collection)val;
            if (col.size() == 0) {
                s = "[]";
            } else {
                int nullCnt = 0;
                int objCnt = 0;
                Class oc = null;
                boolean printable = true;
                Object q = "";
                for (Object o : col) {
                    if (o == null) {
                        ++nullCnt;
                    } else {
                        ++objCnt;
                        oc = oc == null ? o.getClass() : Reflect.commonParent(oc, o.getClass());
                        boolean bl2 = printable = printable && (o instanceof Enum || o instanceof Number || o instanceof Boolean || o instanceof String);
                    }
                    if (!printable) continue;
                    q = (String)q + (((String)q).length() > 0 ? " " : "") + Reflect.formatAsString(o, quote);
                }
                if (printable) {
                    s = "[" + (String)q + "]";
                } else {
                    s = "[";
                    if (objCnt > 0) {
                        s = (String)s + objCnt + " " + (String)(oc.equals(Object.class) ? "objects" : "x " + oc.getName());
                    }
                    if (nullCnt > 0) {
                        s = (String)s + " " + nullCnt + " x null";
                    }
                    s = (String)s + "]";
                }
            }
        } else {
            s = val.toString().replace('\"', '\'');
        }
        if (needQuotes) {
            s = quote + (String)s + quote;
        }
        return s;
    }

    private static Class commonParent(Class a, Class b) {
        Vector vb = new Vector();
        for (Class z = b; z != null; z = z.getSuperclass()) {
            if (a.equals(z)) {
                return a;
            }
            vb.add(z);
        }
        Vector va = new Vector();
        for (Class z = a; z != null; z = z.getSuperclass()) {
            va.add(z);
        }
        int jb = vb.size();
        int ja = va.size();
        Class common = null;
        while (jb > 0 && ja > 0 && ((Class)vb.elementAt(--jb)).equals(va.elementAt(--ja))) {
            common = (Class)vb.elementAt(jb);
        }
        return common;
    }

    public static String csvHeader(Class c) {
        StringBuffer b = new StringBuffer();
        Reflect r = Reflect.getReflect(c);
        for (Entry e : r.entries) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(e.name);
        }
        return b.toString();
    }

    public static String[] getNames(Class c) {
        Reflect r = Reflect.getReflect(c);
        String[] a = new String[r.entries.length];
        int i = 0;
        for (Entry e : r.entries) {
            a[i++] = e.name;
        }
        return a;
    }

    static String getTableName(Object val) {
        throw new IllegalArgumentException("Don't know what table stores objects of the type " + val.getClass() + ". It's time to learn about the 'Entity' annotation");
    }

    private static String escapeStringForSQL(String s) {
        StringBuffer b = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char x = s.charAt(i);
            if (x == '\'') {
                b.append("''");
                continue;
            }
            if (Character.isWhitespace(x)) {
                b.append(" ");
                continue;
            }
            if (x == '%' || x == '\\') {
                b.append("\\" + x);
                continue;
            }
            b.append(x);
        }
        return b.toString();
    }

    public static String saveAsInsert(Object o) {
        Reflect r = Reflect.getReflect(o.getClass());
        StringBuffer b = new StringBuffer("INSERT INTO " + Reflect.getTableName(o));
        StringBuffer names = new StringBuffer();
        StringBuffer values = new StringBuffer();
        for (Entry e : r.entries) {
            String s;
            boolean needQuotes;
            Object val = null;
            try {
                val = e.g.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Logging.error(ex.getMessage());
                val = "ACCESS_ERROR";
            }
            catch (InvocationTargetException ex) {
                Logging.error(ex.getMessage());
                val = "INVOCATION_TARGET_ERROR";
            }
            if (val == null) continue;
            if (names.length() > 0) {
                names.append(",");
            }
            String name = e.name;
            names.append(name);
            boolean bl = val instanceof Enum ? e.enumAsString() : (needQuotes = val instanceof String || val instanceof Date);
            if (values.length() > 0) {
                values.append(",");
            }
            if (needQuotes) {
                values.append("'");
            }
            if (val instanceof Number) {
                s = val.toString();
            } else if (val instanceof Boolean) {
                s = (Boolean)val != false ? "1" : "0";
            } else if (val instanceof Enum) {
                s = e.enumAsString() ? val.toString() : "" + ((Enum)val).ordinal();
            } else if (val instanceof Date) {
                s = sqlDf.format((Date)val);
            } else if (val instanceof String) {
                s = Reflect.escapeStringForSQL((String)val);
            } else {
                throw new IllegalArgumentException("Data type " + val.getClass() + " is not supported. Field = " + e.name);
            }
            values.append(s);
            if (!needQuotes) continue;
            values.append("'");
        }
        b.append(" (" + names + ") VALUES (" + values + ")");
        return b.toString();
    }

    public static class Entry
    implements Comparable {
        public String name;
        public boolean editable;
        public boolean rp;
        public boolean payment;
        public Field f;
        public Method g;
        public Method s;
        double order;

        public int compareTo(Object _o) {
            if (!(_o instanceof Entry)) {
                throw new IllegalArgumentException();
            }
            Entry o = (Entry)_o;
            if (this.order == o.order) {
                return 0;
            }
            if (this.order == 0.0) {
                return 1;
            }
            if (o.order == 0.0) {
                return -1;
            }
            return this.order - o.order > 0.0 ? 1 : -1;
        }

        private boolean enumAsString() {
            Enumerated anno = this.f.getAnnotation(Enumerated.class);
            return anno != null && anno.value() == EnumType.STRING;
        }

        String compactTitle() {
            Display anDisplay = this.f.getAnnotation(Display.class);
            if (anDisplay != null && anDisplay.alt() != null && anDisplay.alt().length() > 0) {
                return anDisplay.alt();
            }
            return this.name;
        }

        String explainedTitle() {
            return this.explainedTitle(false);
        }

        String explainedTitle(boolean html) {
            Display anDisplay = this.f.getAnnotation(Display.class);
            if (anDisplay != null) {
                if (anDisplay.alt() != null && anDisplay.alt().length() > 0) {
                    return anDisplay.alt();
                }
                if (anDisplay.text() != null && anDisplay.text().length() > 0) {
                    return this.name + (html ? "<br><small>" : " ") + "(" + anDisplay.text() + ")" + (html ? "</small>" : "");
                }
            }
            return this.name;
        }

        public boolean isDigest() {
            Display anDisplay = this.f.getAnnotation(Display.class);
            return anDisplay != null && anDisplay.digest();
        }

        public String destName() {
            return this.f.getDeclaringClass().getSimpleName() + "." + this.f.getName();
        }

        public String toString() {
            return "[Reflect.Entry: name=" + this.name + ", f=" + this.f + ", g=" + this.g + ", s=" + this.s + "]";
        }
    }
}

