/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.game.rest;

import edu.wisc.game.formatter.HTMLFmter;
import edu.wisc.game.reflect.JsonToJava;
import edu.wisc.game.sql.Board;
import edu.wisc.game.sql.Episode;
import edu.wisc.game.sql.Piece;
import edu.wisc.game.util.IllegalInputException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/BoardDisplayService")
public class BoardDisplayService {
    private static HTMLFmter fm = new HTMLFmter(null);

    @POST
    @Path(value="/displayBoard")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String displayBoard(@FormParam(value="boardJson") String boardJsonText, @DefaultValue(value="80") @FormParam(value="cellWidth") int cellWidth) {
        String title = "";
        Object body = "";
        try {
            if (boardJsonText == null || boardJsonText.trim().equals("")) {
                throw new IllegalInputException("No board description JSON supplied");
            }
            Board board = Board.readBoardFromString(boardJsonText);
            String s = BoardDisplayService.doBoard(board, cellWidth);
            title = "Board display";
            body = (String)body + fm.para(boardJsonText);
            body = (String)body + fm.para(s);
        }
        catch (Exception ex) {
            title = "Error";
            body = ex.toString();
        }
        return fm.html(title, (String)body);
    }

    private static String doBoard(Board board, int cellWidth) {
        Piece[] pieces = board.asBoardPieces();
        boolean[] isMoveable = new boolean[37];
        return Episode.doHtmlDisplay(pieces, -1, false, isMoveable, cellWidth);
    }

    @Path(value="/displayBoardFile")
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    public String displayBoardFile(@FormDataParam(value="file") FormDataBodyPart parts, @DefaultValue(value="80") @FormDataParam(value="cellWidth") int cellWidth) {
        Object title = "";
        Object body = "";
        try {
            if (parts == null) {
                throw new IllegalInputException("No board description JSON supplied");
            }
            title = "Board display";
            title = (String)title + " (cellWidth=" + cellWidth + ")";
            for (BodyPart part : parts.getParent().getBodyParts()) {
                InputStream file = (InputStream)part.getEntityAs(InputStream.class);
                ContentDisposition fileDisposition = part.getContentDisposition();
                String fileName = fileDisposition.getFileName();
                String type = fileDisposition.getType();
                if (fileName == null) continue;
                Board board = Board.readBoard(new InputStreamReader(file));
                String s = BoardDisplayService.doBoard(board, cellWidth);
                body = (String)body + fm.h3(fileName);
                body = (String)body + fm.para(s);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace(System.err);
            title = "Error";
            body = ex.toString();
        }
        return fm.html((String)title, (String)body);
    }

    @POST
    @Path(value="/displayBoardList")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public String displayBoardList(@FormParam(value="boardListJson") String boardListJsonText, @DefaultValue(value="40") @FormParam(value="cellWidth") int cellWidth, @DefaultValue(value="3") @FormParam(value="ncol") int ncol) {
        Object title = "";
        Object body = "";
        try {
            if (boardListJsonText == null || boardListJsonText.trim().equals("")) {
                throw new IllegalInputException("No board description JSON supplied");
            }
            BoardList boardList = BoardList.readBoardList(new StringReader(boardListJsonText));
            title = "Displaying a list of " + boardList.getBoards().size() + " boards";
            body = (String)body + boardList.htmlFormat(cellWidth, ncol);
        }
        catch (Exception ex) {
            title = "Error";
            body = ex.toString();
        }
        return fm.html((String)title, (String)body);
    }

    @Path(value="/displayBoardListFile")
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    public String displayBoardListFile(@FormDataParam(value="file") InputStream file, @FormDataParam(value="file") FormDataContentDisposition fileDisposition, @DefaultValue(value="40") @FormDataParam(value="cellWidth") int cellWidth, @DefaultValue(value="3") @FormDataParam(value="ncol") int ncol) {
        Object title = "";
        Object body = "";
        try {
            if (file == null) {
                throw new IllegalInputException("No board description JSON supplied");
            }
            BoardList boardList = BoardList.readBoardList(new InputStreamReader(file));
            title = "Displaying a list of " + boardList.getBoards().size() + " boards";
            body = (String)body + boardList.htmlFormat(cellWidth, ncol);
        }
        catch (Exception ex) {
            title = "Error";
            body = ex.toString();
        }
        return fm.html((String)title, (String)body);
    }

    public static class BoardList {
        private Vector<Board> boards = new Vector();

        public void addBoard(Board c) {
            this.boards.add(c);
        }

        public Vector<Board> getBoards() {
            return this.boards;
        }

        public void setBoards(Vector<Board> _boards) {
            this.boards.setSize(0);
            for (Board p : _boards) {
                this.addBoard(p);
            }
        }

        static BoardList readBoardList(Reader r) throws IOException, ReflectiveOperationException {
            JsonReader jsonReader = Json.createReader((Reader)r);
            JsonObject obj = jsonReader.readObject();
            jsonReader.close();
            BoardList boardList = new BoardList();
            JsonToJava.json2java(obj, boardList);
            return boardList;
        }

        String htmlFormat(int cellWidth, int ncol) {
            if (ncol < 1) {
                ncol = 1;
            }
            Object body = "";
            int cnt = 0;
            Vector<String> cells = new Vector<String>();
            Object table = "";
            for (Board board : this.getBoards()) {
                String s = BoardDisplayService.doBoard(board, cellWidth);
                String msg = ++cnt + ") " + board.getName();
                if (ncol == 1) {
                    body = (String)body + fm.h3(msg);
                    body = (String)body + fm.para(s);
                    continue;
                }
                String z = fm.h3(msg) + s;
                cells.add(fm.wrap("td", z));
                if (cells.size() != ncol) continue;
                table = (String)table + fm.wrap("tr", String.join((CharSequence)"", cells));
                cells.clear();
            }
            if (cells.size() > 0) {
                table = (String)table + fm.wrap("tr", String.join((CharSequence)"", cells));
                cells.clear();
            }
            if (!((String)table).equals("")) {
                body = (String)body + fm.wrap("table", (String)table);
            }
            return body;
        }
    }
}

